package zigen.plugin.db.ui.jobs;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;

import zigen.plugin.db.StatusChangeListener;
import zigen.plugin.db.ui.internal.INode;
import zigen.plugin.db.ui.internal.ITable;

public class RefreshTreeNodeAction implements Runnable {

	public static final int MODE_NOTHING = 0; // Ȃ

	public static final int MODE_EXPAND = 1; // WJ

	public static final int MODE_COLLAPSE = 2; // WJɂ

	private TreeViewer viewer;

	private INode treeNode;

	private int mode = MODE_NOTHING;

	public RefreshTreeNodeAction(TreeViewer viewer, INode treeNode, int mode) {
		this.viewer = viewer;
		this.treeNode = treeNode;
		this.mode = mode;
	}

	public RefreshTreeNodeAction(TreeViewer viewer, INode treeNode) {
		this.viewer = viewer;
		this.treeNode = treeNode;
	}

	public void run() {
		if (treeNode != null) {

			switch (mode) {
			case MODE_NOTHING:
				;
				break;
			case MODE_EXPAND:
				viewer.expandToLevel(treeNode, 1);
				break;
			case MODE_COLLAPSE:
				viewer.collapseToLevel(treeNode, 1);
				break;
			default:
				break;
			}

			viewer.refresh(treeNode);

			// IԂēxʒm
			viewer.getControl().notifyListeners(SWT.Selection, null);

			if (treeNode instanceof ITable) {
				// e[uvf̍XVʒm
				StatusChangeListener.fireStatusChangeListener((ITable) treeNode, StatusChangeListener.EVT_RefreshTable);
			}
		}

	}

}
