package zigen.plugin.db.ui.jobs;

import java.sql.Connection;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;

public class TestConnectThread implements Runnable {
	int timeout;

	IDBConfig config;

	boolean isSuccess = false;

	String message;

	public TestConnectThread(IDBConfig config, int timeout) {
		this.config = config;
		this.timeout = timeout;

		StringBuffer sb = new StringBuffer();
		sb.append(Messages.getString("TestConnectThread.0")); //$NON-NLS-1$
		sb.append(Messages.getString("TestConnectThread.1")); //$NON-NLS-1$
		message = sb.toString();
	}

	public void run() {
		Connection con = null;
		Transaction trans = Transaction.getInstance(config);

		try {
			con = trans.getConnection();
			this.isSuccess = true;
			this.message = Messages.getString("TestConnectThread.2"); //$NON-NLS-1$

		} catch (Exception e) {
			DbPlugin.log(e);
			this.message = e.getMessage();
			this.isSuccess = false;

		} finally {
			if (isSuccess) {
				trans.cloesConnection();
			}
		}
	}

	public boolean isSuccess() {
		return isSuccess;
	}

	public String getMessage() {
		return message;
	}

}
