/*
 * 쐬: 2005/03/09
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.StatusChangeListener;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.util.ResourceUtil;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class SQLExecuteView extends AbstractSQLExecuteView {

	public void createToolbarPart(Composite header) {
		Composite tool = new Composite(header, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		// layout.numColumns = 3;

		layout.makeColumnsEqualWidth = false;
		layout.marginHeight = 2;
		layout.marginWidth = 2;
		layout.horizontalSpacing = 2;
		layout.verticalSpacing = 2;
		tool.setLayout(layout);
		ToolBar toolbar = new ToolBar(tool, SWT.FLAT);
		execItem = new ToolItem(toolbar, SWT.PUSH);
		execItem.setText(Messages.getString("SQLExecuteView.0")); //$NON-NLS-1$
		// execItem.setImage(ic.getImage(DbPlugin.IMG_CODE_EXECUTE));
		execItem.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (sqlViewer.canDoOperation(ISQLOperationTarget.ALL_EXECUTE)) {
					sqlViewer.doOperation(ISQLOperationTarget.ALL_EXECUTE);
				}
			}
		});
		clearItem = new ToolItem(toolbar, SWT.PUSH);
		clearItem.setText(Messages.getString("SQLExecuteView.1")); //$NON-NLS-1$
		// clearItem.setImage(ic.getImage(DbPlugin.IMG_CODE_CLEAR));
		clearItem.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (sqlViewer.canDoOperation(ISQLOperationTarget.ALL_CLEAR)) {
					sqlViewer.doOperation(ISQLOperationTarget.ALL_CLEAR);
				}
			}
		});
		prevItem = new ToolItem(toolbar, SWT.PUSH);
		prevItem.setText(Messages.getString("SQLExecuteView.2")); //$NON-NLS-1$
		// prevItem.setImage(ic.getImage(DbPlugin.IMG_CODE_BACK));
		prevItem.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (sqlViewer.canDoOperation(ISQLOperationTarget.BACK_SQL)) {
					sqlViewer.doOperation(ISQLOperationTarget.BACK_SQL);
				}
			}
		});
		nextItem = new ToolItem(toolbar, SWT.PUSH);
		nextItem.setText(Messages.getString("SQLExecuteView.3")); //$NON-NLS-1$
		// nextItem.setImage(ic.getImage(DbPlugin.IMG_CODE_FORWARD));
		nextItem.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (sqlViewer.canDoOperation(ISQLOperationTarget.NEXT_SQL)) {
					sqlViewer.doOperation(ISQLOperationTarget.NEXT_SQL);
				}
			}
		});
		// Zp[^
		// ToolItem sep3 = new ToolItem(toolbar, SWT.SEPARATOR);
		commitItem = new ToolItem(toolbar, SWT.PUSH);
		commitItem.setText(Messages.getString("SQLExecuteView.4")); //$NON-NLS-1$
		// commitItem.setImage(ic.getImage(DbPlugin.IMG_CODE_COMMIT));
		commitItem.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				commitAction.run();
				// setFocus(); // tH[JX
			}
		});
		rollbackItem = new ToolItem(toolbar, SWT.PUSH);
		rollbackItem.setText(Messages.getString("SQLExecuteView.5")); //$NON-NLS-1$
		// rollbackItem.setImage(ic.getImage(DbPlugin.IMG_CODE_ROLLBACK));
		rollbackItem.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				rollbackAction.run();
				// setFocus(); // tH[JX
			}
		});
		formatItem = new ToolItem(toolbar, SWT.PUSH);
		formatItem.setText(Messages.getString("SQLExecuteView.6")); //$NON-NLS-1$
		formatItem.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (sqlViewer.canDoOperation(ISQLOperationTarget.FORMAT)) {
					sqlViewer.doOperation(ISQLOperationTarget.FORMAT);
				}
			}
		});
		// gO{^
		autoCommitItem = new ToolItem(toolbar, SWT.CHECK);
		autoCommitItem.setText(AUTO_COMMIT);
		autoCommitItem.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				autoCommitSelectHandler();
			}
		});

		/*
		 * showHistoryItem = new ToolItem(toolbar, SWT.CHECK);
		 * showHistoryItem.setText(""); //
		 * showHistoryItem.setImage(ic.getImage(DbPlugin.IMG_CODE_CLOCK));
		 * showHistoryItem.addSelectionListener(new SelectionAdapter() { public
		 * void widgetSelected(SelectionEvent e) {
		 * showHistoryViewSelectHandler(showHistoryItem); } });
		 */

		ToolItem sep7 = new ToolItem(toolbar, SWT.SEPARATOR);
		// SelectBox̍쐬
		createSelectCombo(tool);

	}

	void autoCommitSelectHandler() {
		if (autoCommitItem.getSelection()) {
			// R~bg̏ꍇ́AR~bgA[obN{^͔񊈐
			if (trans == null || trans.getTransactionCount() == 0) {
				setCommitMode(true);

			} else {
				// [obN̊mF_CAON
				DbPlugin.getDefault().showWaringMessage(Messages.getString("SQLExecuteView.7")); //$NON-NLS-1$
				setCommitMode(false);
			}
		} else {
			setCommitMode(false);
		}

		// SĂSQLsr[ɒʒmAR~bg[h킹
		StatusChangeListener.fireStatusChangeListener(this, StatusChangeListener.EVT_ChangeTransactionMode);
	}

	void createSelectCombo(Composite tool) {
		selectCombo = new Combo(tool, SWT.READ_ONLY);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 200;
		selectCombo.setLayoutData(data);
		updateCombo(null); // N̏ꍇNULL
		selectCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				int index = selectCombo.getSelectionIndex();
				config = configs[index];
				setLastSelectedDBName(config.getDbName());
				changeTransaction(config);
			}
		});

	}

	public void selectionChangeHandler(SelectionChangedEvent event) {
		ISelection selection = event.getSelection();
		if (selection instanceof TextSelection) {
			TextSelection textSelection = (TextSelection) selection;
			// executeSelectedSQLAction.setSelection(textSelection);

			if (textSelection.getLength() > 0) {
				// executeSelectedSQLAction.setEnabled(true);
				if (config != null && config.getDbType() == DBType.DB_TYPE_ORACLE) {
					explainForQueryAction.setEnabled(true);// Oraclê݁usvv̎s\
				}
			} else {
				// executeSelectedSQLAction.setEnabled(false);
				explainForQueryAction.setEnabled(false);
			}

		} else {
			// executeSelectedSQLAction.setSelection(null);
			// executeSelectedSQLAction.setEnabled(false);
			explainForQueryAction.setEnabled(false);
		}
	}

	public void statusChanged(Object obj, int status) {
		if (obj instanceof HistoryView) {
			switch (status) {
			case SWT.Selection:
				if (showHistoryViewAction != null)
					showHistoryViewAction.setChecked(true);
				break;
			case SWT.Dispose:
				if (showHistoryViewAction != null)
					showHistoryViewAction.setChecked(false);
				break;
			case StatusChangeListener.EVT_UpdateHistory: // SQL{^XV
				updateHistoryButton();
				break;
			default:
				break;
			}

		} else if (obj instanceof SQLExecuteView) {
			SQLExecuteView view = (SQLExecuteView) obj;
			switch (status) {
			case StatusChangeListener.EVT_ChangeTransactionMode: // R~bg[hύX
				updateCombo(view.config);
				break;
			default:
				break;
			}

		} else if (obj instanceof SQLSourceViewer) {
			switch (status) {
			case StatusChangeListener.EVT_UpdateHistory: // SQL{^XV
				updateHistoryButton();
				break;
			default:
				break;
			}
            
		} else if(obj instanceof IDBConfig){
            
            if(status == StatusChangeListener.EVT_ChangeDataBase){
                updateCombo((IDBConfig)obj);
            }
        }        
	}

}
