package zigen.plugin.db;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ImageCacher {

	private static ImageCacher instance;

	private Map map;

	/**
	 * CX^X
	 * 
	 * @param<code>_instance</code>
	 */
	public synchronized static ImageCacher getInstance() {
		if (instance == null) {
			instance = new ImageCacher();
		}
		return instance;
	}

	/**
	 * RXgN^
	 */
	private ImageCacher() {
		this.map = new HashMap();
		init();
	}

	private void init() {
		createImage(DbPlugin.IMG_CODE_BACK);
		createImage(DbPlugin.IMG_CODE_BOOKMARK);
		createImage(DbPlugin.IMG_CODE_CLOCK);

		createImage(DbPlugin.IMG_CODE_COLUMN);

		createImage(DbPlugin.IMG_CODE_DB_ADD);
		createImage(DbPlugin.IMG_CODE_DB_COPY);

		createImage(DbPlugin.IMG_CODE_DB_DELETE);
		createImage(DbPlugin.IMG_CODE_DB);
		createImage(DbPlugin.IMG_CODE_CONNECTED_DB);

		createImage(DbPlugin.IMG_CODE_FORWARD);
		createImage(DbPlugin.IMG_CODE_DB_NEW);

		createImage(DbPlugin.IMG_CODE_NOTNULL_COLUMN);
		createImage(DbPlugin.IMG_CODE_PK_COLUMN);

		createImage(DbPlugin.IMG_CODE_REFRESH);

		createImage(DbPlugin.IMG_CODE_SCHEMA);
		createImage(DbPlugin.IMG_CODE_SQL);
		createImage(DbPlugin.IMG_CODE_TABLE);
		createImage(DbPlugin.IMG_CODE_DISABLED_TABLE);
		createImage(DbPlugin.IMG_CODE_DISABLED_SYNONYM);

		createImage(DbPlugin.IMG_CODE_ASC);
		createImage(DbPlugin.IMG_CODE_DESC);
		createImage(DbPlugin.IMG_CODE_BLANK);
		createImage(DbPlugin.IMG_CODE_SAVE);
		createImage(DbPlugin.IMG_CODE_UNKNOWN);

		createImage(DbPlugin.IMG_CODE_CHECKED);
		createImage(DbPlugin.IMG_CODE_UNCHECKED);
		createImage(DbPlugin.IMG_CODE_DISABLED_CHECKED);

		createImage(DbPlugin.IMG_CODE_CHECKED_CENTER);
		createImage(DbPlugin.IMG_CODE_UNCHECKED_CENTER);
		createImage(DbPlugin.IMG_CODE_DISABLED_CHECKED_CENTER);

		createImage(DbPlugin.IMG_CODE_TEMPLATE);

		createImage(DbPlugin.IMG_CODE_VIEW);
		createImage(DbPlugin.IMG_CODE_FUNCTION);
		createImage(DbPlugin.IMG_CODE_SYNONYM);
		createImage(DbPlugin.IMG_CODE_SEQUENCE);

		createImage(DbPlugin.IMG_CODE_EXECUTE);
		createImage(DbPlugin.IMG_CODE_CLEAR);
		createImage(DbPlugin.IMG_CODE_COMMIT);
		createImage(DbPlugin.IMG_CODE_ROLLBACK);

		createImage(DbPlugin.IMG_CODE_IMPORT);
		createImage(DbPlugin.IMG_CODE_EXPORT);

		createImage(DbPlugin.IMG_CODE_FORMAT);

		createImage(DbPlugin.IMG_CODE_VERTICALLAYOUT);
		createImage(DbPlugin.IMG_CODE_HORIZONTALLAYOUT);

		createImage(DbPlugin.IMG_CODE_REMOVE);
		createImage(DbPlugin.IMG_CODE_REMOVE_ALL);

		createImage(DbPlugin.IMG_CODE_PIN);

		createImage(DbPlugin.IMG_CODE_OPEN);
		
		createImage(DbPlugin.IMG_CODE_SYNCED);

	}

	public Image getImage(String imageCode) {
		if (map.containsKey(imageCode)) {
			return (Image) map.get(imageCode);
		} else {
			return null;
		}
	}

	private void createImage(String imageCode) {
		DbPlugin plugin = DbPlugin.getDefault();
		ImageDescriptor id = plugin.getImageDescriptor(imageCode);
		if (id != null) {
			map.put(imageCode, id.createImage());
		} else {
			DbPlugin.log(Messages.getString("ImageCacher.Error") + imageCode); //$NON-NLS-1$
			
		}
	}

	public void clear() {
		this.map = null;
	}

}
