package zigen.plugin.db.ui.editors.internal.invoker;

import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.ITable;

public class AddCheckInvoker extends AbstractSQLInvoker {

	private static String TITLE = Messages.getString("AddCheckInvoker.0"); //$NON-NLS-1$

	String constraintName;

	String check;

	public AddCheckInvoker(ITable table, String constraintName, String check) {
		super(TITLE, table);
		this.constraintName = constraintName;
		this.check = check;
	}

	public String[] createSQL(ISQLCreatorFactory factory, ITable table) {
		String sql = factory.createCreateConstraintCheckDDL(constraintName, check);
		return new String[] {
			sql
		};
	}

}