/*
 * 쐬: 2005/07/30
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.core;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * SqlUtilNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/07/30 ZIGEN create.
 * 
 */
public class SQLUtil {

	/**
	 * 񒆂́u'vDBANZX\ɕϊB
	 * 
	 * @param strSrc
	 *            ̕
	 * @return ϊ̕
	 */
	public static final String encodeQuotation(String str) {
		int nLen = str.length();
		StringBuffer sb = new StringBuffer(nLen * 2);
		for (int i = 0; i < nLen; i++) {
			char c = str.charAt(i);
			if (c == '\'') {
				sb.append("''");
			} else {
				sb.append(c);
			}
		}
		return sb.toString();
	}

	/**
	 * 񒆂́u%v,u_v,u\vDBANZX\ɕϊB gꍇ́AESCAPE 傪Kvł
	 * 
	 * @param strSrc
	 *            ̕
	 * @return ϊ̕
	 */
	public static final String encodeEscape(String str) {
		int nLen = str.length();
		StringBuffer sb = new StringBuffer(nLen * 2);
		for (int i = 0; i < nLen; i++) {
			char c = str.charAt(i);
			switch (c) {
			case '%':
				sb.append("\\%");
				break;
			case '_':
				sb.append("\\_");
				break;
			case '\\':
				sb.append("\\\\");
				break;
			default:
				sb.append(c);
				break;
			}
		}
		return sb.toString();
	}


	
    static final String PATTERN_PLSQL_FUNCTION = "^create[ \n]+(or[ \n]+replace|)[ \n]+(function)[ \n]+.*";
    static final String PATTERN_PLSQL_PROCEDURE = "^create[ \n]+(or[ \n]+replace|)[ \n]+(procedure)[ \n]+.*";
    static final String PATTERN_PLSQL_TRIGGER = "^create[ \n]+(or[ \n]+replace|)[ \n]+(trigger)[ \n]+.*";
    static final String PATTERN_PLSQL_PACKAGE = "^create[ \n]+(or[ \n]+replace|)[ \n]+(package)[ \n]+.*";
    static final String PATTERN_PLSQL_PACKAGE_BODY = "^create[ \n]+(or[ \n]+replace|)[ \n]+(package[ \n]+body)[ \n]+.*";

    static final String PATTERN_REMOVE2 = "create|or|replace|function|procedure|trigger|package|body|\\p{Space}|\\(\\p{ASCII}*$";

    private static String getPlsqlType(String sql) throws Exception {
        String s = StringUtil.removeComment(sql); // /* Rg*/ O
        s = StringUtil.removeLineComment(s); // -- Rg O
        s = StringUtil.removeLeftFullSpace(s); // ̕svȑSpXy[XO
        s = StringUtil.lTrim(s, ' ');           // ̕svȔpXy[XO
        
        Pattern pattern = null;
        Matcher matcher = null;
        
        pattern = Pattern.compile(PATTERN_PLSQL_FUNCTION, Pattern.CASE_INSENSITIVE);
        matcher = pattern.matcher(s);
        if(matcher.matches()){
            return "FUNCTION";
        }
        
        pattern = Pattern.compile(PATTERN_PLSQL_PROCEDURE, Pattern.CASE_INSENSITIVE);
        matcher = pattern.matcher(s);
        if(matcher.matches()){
            return "PROCEDURE";
        }
        
        pattern = Pattern.compile(PATTERN_PLSQL_TRIGGER, Pattern.CASE_INSENSITIVE);
        matcher = pattern.matcher(s);
        if(matcher.matches()){
            return "TRIGGER";
        }
        
        // Package body  Packageɔ肷邱ƁB
        pattern = Pattern.compile(PATTERN_PLSQL_PACKAGE_BODY, Pattern.CASE_INSENSITIVE);
        matcher = pattern.matcher(s);
        if(matcher.matches()){
            return "PACKAGE_BODY";
        }
        
        pattern = Pattern.compile(PATTERN_PLSQL_PACKAGE, Pattern.CASE_INSENSITIVE);
        matcher = pattern.matcher(s);
        if(matcher.matches()){
            return "TYPE_PACKAGE";
        }
        return null;
    }
    private static String getSchemaAndPlSqlName(String plsql) throws Exception {
        String s = StringUtil.removeComment(plsql); // /* Rg*/ O
        s = StringUtil.removeLineComment(s); // -- Rg O
        s = StringUtil.removeLeftFullSpace(s); // ̕svȑSpXy[XO
        s = StringUtil.lTrim(s, ' ');           // ̕svȔpXy[XO
        Pattern pattern1 = Pattern.compile(PATTERN_REMOVE2, Pattern.CASE_INSENSITIVE);
        Matcher matcher1 = pattern1.matcher(s);
        s = matcher1.replaceAll("");
        return s;
    }

    public static Plsql getPlsql(String plsql) throws Exception {
        Plsql vo = new Plsql();
        vo.setType(getPlsqlType(plsql));
        String schemaAndPlSqlName = getSchemaAndPlSqlName(plsql);
        int pos = schemaAndPlSqlName.indexOf('.');
        if(pos == -1){
            vo.schema = null;
            vo.name = schemaAndPlSqlName;
        }else{
            vo.schema = schemaAndPlSqlName.substring(0, pos);
            vo.name = schemaAndPlSqlName.substring(pos+1);
        }
        return vo;
    }

    public static void main(String[] args){
        String s = "CREATE    \n   \n  OR REPLACE FUNCTION A.BAK_SF_TOTAL_NENDO()RETURN NUMBER (hoge, hoge) END";
        try {
            Plsql vo = getPlsql(s);            
            System.out.println(vo.getSchema());
            System.out.println(vo.getName());
            System.out.println(vo.getType());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
    
	public static boolean isSelect(String sql) throws Exception {
		String s = StringUtil.removeComment(sql); // /* Rg*/ O
		s = StringUtil.removeLineComment(s); // -- Rg O
		s = StringUtil.removeLeftFullSpace(s); // ̕svȑSpXy[XO
		s = s.trim(); // svȉs菜

		if (s.startsWith("(")) {
			s = s.substring(1);
			if (s.endsWith(")")) {
				s = s.substring(0, s.length() - 1);
				return isSelect(s);
			} else {
				throw new IllegalArgumentException("SQLɌ肪܂B')'܂");
			}
		} else {
			// SELECT
			s = s.toUpperCase(); // 啶Ŕ肷
			if (s.startsWith("SELECT") || s.startsWith("SHOW")) {
				return true;
			} else {
				return false;
			}

		}

	}

	/**
	 * "hogehoge", 'hogehoge'ȊO̕Sđ啶ɕϊ
	 * 
	 * @param sql
	 * @return
	 */
	public static String toUpperCase(String sql) {
		return toCase(sql, MODE_TO_UPPER);
	}

	/**
	 * "hogehoge", 'hogehoge'ȊO̕Sďɕϊ
	 * 
	 * @param sql
	 * @return
	 */
	public static String toLowerCase(String sql) {
		return toCase(sql, MODE_TO_LOWER);
	}

	private static final int MODE_TO_UPPER = 1;

	private static final int MODE_TO_LOWER = 2;

	private static String toCase(String sql, int mode) {
		StringBuffer sb = new StringBuffer();
		StringTokenizer t = new StringTokenizer(sql, " ");
		String token = null;
		int indent = 0;
		int preIndent = 0; // 1ÕCfg

		while ((token = t.nextToken()) != null) {
			if (token.trim().length() == 0) {
				indent++;
			} else {
				StringBuffer buff = new StringBuffer();
				Tokenizer tokenizer = new Tokenizer(token);
				while (tokenizer.nextToken() != Tokenizer.TT_EOF) {
					String token2 = tokenizer.getToken();
					String temp = token2.trim();
					if (temp.startsWith("'") && temp.endsWith("'")) {
						;// ϊȂ
					} else if (temp.startsWith("\"") && temp.endsWith("\"")) {
						;// ϊȂ
					} else {
						if (mode == MODE_TO_UPPER) {
							token2 = token2.toUpperCase();
						} else {
							token2 = token2.toLowerCase();
						}
					}
					buff.append(token2);
				}

				if (sb.length() == 0) {
					sb.append(buff.toString());

				} else {
					sb.append(" ");
					sb.append(StringUtil.indent(buff.toString(), indent));
				}

				preIndent = indent;
				indent = 0;

			}
		}

		return sb.toString();
	}

}

class Tokenizer extends StreamTokenizer {

	public final static char TT_SPACE = ' ';

	public final static char TT_QUOTE = '\'';

	public final static char TT_DOUBLE_QUOTE = '"';

	public final static char TT_COMMA = ',';

	public final static int TT_SYMBOL = -100;

	public final static int TT_SQL_KEYWORD = -200;

	private int tokenType = TT_EOF;

	private String token;

	public Tokenizer(String sql) {
		super(new StringReader(sql));
		resetSyntax();
		wordChars('0', '9');
		wordChars('a', 'z');
		wordChars('A', 'Z');
		wordChars('_', '_');
		wordChars(' ', ' ');
		wordChars('\'', '\'');
		wordChars('"', '"');
		wordChars('\n', '\n');
		wordChars('\r', '\r');
		wordChars('.', '.'); // sIhł͕Ȃ
		wordChars('*', '*'); // *ł͕Ȃ
		wordChars('/', '/'); // /ł͕Ȃ
		// quoteChar(TT_QUOTE);
		// quoteChar(TT_DOUBLE_QUOTE);
		// tokenizer.parseNumbers(); // ͂Ȃ
		eolIsSignificant(false);// EOL̔false
		// slashStarComments(true);
		// slashSlashComments(true);
	}

	public int nextToken() {
		try {
			tokenType = super.nextToken();

			switch (tokenType) {
			case Tokenizer.TT_EOF:
				tokenType = Tokenizer.TT_EOF;
				token = null;
				break;

			case Tokenizer.TT_WORD:
				token = sval;
				if (isNumeric(token)) {
					tokenType = Tokenizer.TT_NUMBER;
				}
				break;
			case Tokenizer.TT_QUOTE:
				token = "'" + sval + "'";
				break;
			case Tokenizer.TT_DOUBLE_QUOTE:
				token = "\"" + sval + "\"";
				break;

			default:
				token = String.valueOf((char) ttype);
			}

		} catch (IOException e) {
			e.printStackTrace();
		}

		return tokenType;
	}

	public int getTokenType() {
		return tokenType;
	}

	public String getToken() {
		return token;
	}

	boolean isNumeric(String text) {
		for (int i = 0; i < text.length(); i++) {
			char chr = text.charAt(i);
			if (!(chr >= '0' && chr <= '9')) {
				return false;
			}
		}
		return true;
	}

}

