/*
 * 쐬: 2005/08/21
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.dialogs;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.Wizard;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfig;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.DriverManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SameDbNameException;

/**
 * TestWizardNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/08/21 ZIGEN create.
 * 
 */
public class DBConfigWizard extends Wizard {

	IDBConfig oldConfig; // DBڑ`

	IDBConfig newConfig; // XMLɓo^DBConfigIuWFNg

	private WizardPage1 page1;

	private WizardPage2 page2;

	private WizardPage3 page3;

	private ISelection selection;

	public DBConfigWizard(ISelection selection) {
		this(selection, null);
	}

	public DBConfigWizard(ISelection selection, IDBConfig oldConfig) {
		super();
		super.setWindowTitle(Messages.getString("DBConfigWizard.0")); //$NON-NLS-1$
		this.selection = selection;
		this.oldConfig = oldConfig;

		setNeedsProgressMonitor(true);
		setHelpAvailable(false);

	}

	public void addPages() {

		page1 = new WizardPage1(selection);
		page2 = new WizardPage2(selection);
		page3 = new WizardPage3(selection);

		addPage(page1);
		addPage(page2);
		addPage(page3);
	}

	public boolean performFinish() {
		try {
			newConfig = createNewConfig();

			// VKC𔻒
			if (oldConfig == null) {
				// VKۑ
				DBConfigManager.save(newConfig);
			} else {
				// C
				DBConfigManager.modify(oldConfig, newConfig);
			}

			// SQLExecuteViewDBXgiR{{bNXj̍XV
			// updateComboOfSQLViewer(newConfig);

			// DriverManager̃LbVNA
			DriverManager.getInstance().removeCach(newConfig);

			return true;

		} catch (SameDbNameException e) {
			DbPlugin.getDefault().showWarningMessage(e.getMessage());

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
		return false;

	}

	// I[o[Ch
	public boolean canFinish() {
		if (page1.isPageComplete() && page2.isPageComplete() && page3.isPageComplete()) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * DBڑ̕ۑ
	 * 
	 * @return
	 */
	protected IDBConfig createNewConfig() {
		DBConfig config = new DBConfig();

		try {
			config.setDbName(page1.nameText.getText());
			config.setClassPaths((String[]) page1.classpathList.toArray(new String[0]));

			config.setDriverName(page2.driverCombox.getText());

			config.setUrl(page2.urlText.getText());
			config.setUserId(page2.userIdText.getText());
			config.setSchema(page2.schemaText.getText());
			config.setPassword(page2.passwordText.getText());

			if (page2.radio2.getSelection()) {
				config.setJdbcType(DBConfig.JDBC_DRIVER_TYPE_2);
			} else {
				config.setJdbcType(DBConfig.JDBC_DRIVER_TYPE_4);
			}

			config.setCharset(page3.charsetText.getText());
			config.setConvertUnicode(page3.unicodeCheck.getSelection());
			config.setAutoCommit(page3.commitModeCheck.getSelection());
			config.setOnlyDefaultSchema(page3.schemaOnlyCheck.getSelection());

			config.setNoLockMode(page3.symfowareOptionCheck.getSelection());

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}
		return config;
	}

	public IDBConfig getNewConfig() {
		return newConfig;
	}

}
