/*
 * 쐬: 2005/05/13
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.editors.internal.action;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.actions.TableViewEditorAction;
import zigen.plugin.db.ui.editors.internal.wizard.ColumnWizard;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.TreeNode;

public class AddColumnAction extends TableViewEditorAction {

	public AddColumnAction() {
		this.setText(Messages.getString("AddColumnAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("AddColumnAction.1")); //$NON-NLS-1$
		this.setImageDescriptor(ISharedImages.IMG_TOOL_NEW_WIZARD);
	}

	public void run() {

		IDBConfig config = editor.getDBConfig();
		ITable tableNode = editor.getTableNode();
		ISQLCreatorFactory factory = AbstractSQLCreatorFactory.getFactory(config, tableNode);

		zigen.plugin.db.core.TableColumn tCol = new zigen.plugin.db.core.TableColumn();
		Column col = new Column();
		col.setColumn(tCol);
		col.setParent((TreeNode) tableNode);

		Shell shell = DbPlugin.getDefault().getShell();

		/*
		 * TableDefineInputDialog dialog = new TableDefineInputDialog(shell,
		 * factory, tableNode, col, true); if (dialog.open() != Window.OK) { }
		 */

		ColumnWizard wizard = new ColumnWizard(factory, tableNode, col, true);
		WizardDialog dialog2 = new WizardDialog(shell, wizard);
		int ret = dialog2.open();
		if (ret == IDialogConstants.OK_ID) {
		}

	}

}
