package zigen.plugin.db.ui.views.internal;

import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.widgets.Composite;

import zigen.plugin.db.ui.views.ISQLOperationTarget;

public class PLSQLSourceViewer extends SQLSourceViewer implements ISQLOperationTarget {

	// public PLSQLSourceViewer(Composite parent, IVerticalRuler ruler, int
	// styles) {
	// super(parent, ruler, styles);
	// }

	public PLSQLSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
		super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
	}

	public boolean canDoOperation(int operation) {
		if (operation == ISQLOperationTarget.FORMAT || operation == ISQLOperationTarget.UNFORMAT) {
			return false;
		}

		switch (operation) {
		case ISQLOperationTarget.ALL_EXECUTE:
		case ISQLOperationTarget.CURRENT_EXECUTE:
		case ISQLOperationTarget.SELECTED_EXECUTE:
		case ISQLOperationTarget.LINE_DEL:
		case ISQLOperationTarget.COMMENT:

			return isEditable();

		case ISQLOperationTarget.NEXT_SQL:
		case ISQLOperationTarget.BACK_SQL:
		case ISQLOperationTarget.FORMAT:
		case ISQLOperationTarget.UNFORMAT:
		case ISQLOperationTarget.COMMIT:
		case ISQLOperationTarget.ROLLBACK:
			return false;

		default:
			return super.canDoOperation(operation);
		}

	}
}
