package zigen.plugin.db;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import zigen.plugin.db.ui.views.IStatusChangeListener;

public class StatusChangeListener {

	public static final int EVT_UpdateHistory = 101;

	public static final int EVT_ChangeTransactionMode = 102;

	public static final int EVT_ModifyTableDefine = 103;

	public static final int EVT_RefreshTable = 104; // e[u`XV
	
	public static final int EVT_LinkTable = 105; // e[uN
	
    public static final int EVT_ChangeDataBase = 106;
    
    public static final int EVT_UpdateDataBaseList = 107;

	private static List listeners = new ArrayList();

	public static void addStatusChangeListener(IStatusChangeListener listener) {
		if (!listeners.contains(listener))
			listeners.add(listener);
	}

	public static void removeStatusChangeListener(IStatusChangeListener listener) {
		listeners.remove(listener);
	}

	public static void fireStatusChangeListener(Object obj, int status) {
		for (Iterator iter = listeners.iterator(); iter.hasNext();) {
			IStatusChangeListener element = (IStatusChangeListener) iter.next();
			if (element != null) {
				element.statusChanged(obj, status);
			}
		}

	}

}
