/*
 * 쐬: 2005/03/12
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.csv;

import java.io.File;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.preference.CSVPreferencePage;
import zigen.plugin.db.ui.editors.QueryViewEditor2;

/**
 * CreateCSVActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/07/08 ZIGEN create.
 * 
 */
public class CreateCSVForQueryAction extends Action {

	protected QueryViewEditor2 editor;

	private IPreferenceStore store;

	/**
	 * RXgN^
	 * 
	 * @param viewer
	 */
	public CreateCSVForQueryAction() {
		this.setText(Messages.getString("CreateCSVForQueryAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("CreateCSVForQueryAction.1")); //$NON-NLS-1$
		this.store = DbPlugin.getDefault().getPreferenceStore();
	}

	public void setActiveEditor(QueryViewEditor2 queryEditor) {
		editor = queryEditor;
	}

	/**
	 * Actions̏
	 */
	public void run() {
		// 1Ȃꍇ
		invoke();

	}

	private void invoke() {

		try {
			Shell shell = DbPlugin.getDefault().getShell();
			FileDialog dialog = new FileDialog(shell, SWT.SAVE);
			dialog.setFileName("query"); //$NON-NLS-1$
			dialog.setFilterExtensions(new String[] {
					"*.csv", "*.*" //$NON-NLS-1$ //$NON-NLS-2$
			});
			dialog.setFilterNames(new String[] {
					Messages.getString("CreateCSVForQueryAction.5"), Messages.getString("CreateCSVForQueryAction.6") //$NON-NLS-1$ //$NON-NLS-2$
					});
			String fileName = dialog.open();

			// LZ̏
			if (fileName == null)
				return;

			File csvFile = new File(fileName);
			if (csvFile.exists()) {
				// Shell shell = DbPlugin.getDefault().getShell();
				MessageBox msg = new MessageBox(shell, SWT.YES | SWT.NO | SWT.ICON_QUESTION);
				msg.setMessage(fileName + Messages.getString("CreateCSVForQueryAction.7")); //$NON-NLS-1$
				msg.setText(Messages.getString("CreateCSVForQueryAction.8")); //$NON-NLS-1$
				int res2 = msg.open();
				if (res2 == SWT.NO)
					return;
			}

			String encoding = store.getString(CSVPreferencePage.P_ENCODING);
			
			// [1] 2007/11/08 JX^}CY start 
			String separator = store.getString(CSVPreferencePage.P_DEMILITER);
			boolean nonHeader = store.getBoolean(CSVPreferencePage.P_NON_HEADER);
            boolean nonDoubleQuate = store.getBoolean(CSVPreferencePage.P_NON_DOUBLE_QUATE);
			// [1] 2007/11/08 JX^}CY end
			
			
			CSVConfig config = new CSVConfig();
			config.setQuery(editor.getQuery());
			// config.setCsvEncoding("Shift_JIS"); // ݌Œ
			config.setCsvEncoding(encoding);

			// [1] 2007/11/08 JX^}CY start 
			config.setSeparator(separator);
			config.setNonHeader(nonHeader);
			config.setNonDoubleQuate(nonDoubleQuate);
			// [1] 2007/11/08 JX^}CY end
			
			config.setCsvFile(fileName);
			CSVWriter writer = new CSVWriter(editor.getDBConfig(), config);
			writer.execute();

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}

	}

}
