/*
 * 쐬: 2005/03/24
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.JDBCUnicodeConvertor;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;

/**
 * OracleColumnSearcherNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/10/01 ZIGEN create.
 * 
 */
public class OracleColumnSearcher {

	public static OracleColumnInfo[] execute(IDBConfig config, String owner, String table) throws Exception {
		try {
			Connection con = Transaction.getInstance(config).getConnection();
			return execute(con, owner, table, config.isConvertUnicode());

		} catch (Exception e) {
			throw e;
		}
	}

	public static OracleColumnInfo[] execute(Connection con, String owner, String table, boolean convertUnicode) throws Exception {
		List list = null;
	    ResultSet rs = null;
		Statement st = null;
		try {
			st = con.createStatement();
			rs = st.executeQuery(getSQL(owner, table, getDatabaseMajorVersion(con)));

			list = new ArrayList();
			while (rs.next()) {
			    OracleColumnInfo info = new OracleColumnInfo();
			    info.setColumn_name(rs.getString("COLUMN_NAME"));
			    info.setData_type(rs.getString("DATA_TYPE"));
			    info.setData_precision(rs.getBigDecimal("DATA_PRECISION"));
			    info.setData_scale(rs.getBigDecimal("DATA_SCALE"));
                info.setData_default(rs.getString("DATA_DEFAULT"));
			    info.setComments(rs.getString("COMMENTS"));
			    			    
				if (convertUnicode) {
				    info.setColumn_name(JDBCUnicodeConvertor.convert(info.getColumn_name()));
				    info.setData_type(JDBCUnicodeConvertor.convert(info.getData_type()));
				    info.setData_default(JDBCUnicodeConvertor.convert(info.getData_default()));
                    info.setComments(JDBCUnicodeConvertor.convert(info.getComments()));
				}

				list.add(info);
			}
			return (OracleColumnInfo[])list.toArray(new OracleColumnInfo[0]);

		} catch (Exception e) {
			DbPlugin.log(e);
			throw e;
		} finally {
			ResultSetUtil.close(rs);
			StatementUtil.close(st);
		}

	}

	private static int getDatabaseMajorVersion(Connection con){
		int version = 0;
		try {
			version = con.getMetaData().getDatabaseMajorVersion();
		} catch (SQLException e) {
			//System.err.println(e.getMessage());
		}
		return version;
	}
	
	// OraclepSQL
	private static String getSQL(String owner, String table, int databaseProductMajorVersion) {
		
		
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT");
		sb.append("        COL.COLUMN_NAME");
		sb.append("        ,COL.DATA_TYPE");
		//sb.append("        ,COL.DATA_PRECISION");

		
		if(databaseProductMajorVersion <= 8){
			// for Oracle8i
			// Oracle 8i ł́AALL_TAB_COLUMNSCHAR_LENGTH݂Ȃ߁ADATA_TYPEgB
			// NUMBER^̏ꍇ́ADATA_PRECISION悤ɕύXǍ^ǉKv邩						
			sb.append("        ,DECODE(COL.DATA_TYPE, 'NUMBER', COL.DATA_PRECISION, COL.DATA_LENGTH) DATA_PRECISION");
		}else{
			// for Oracle 9i, 10g
			// CHAR_LENGTHgāAl^̌ƕ^̌𔻒肷
			sb.append("        ,DECODE(CHAR_LENGTH, 0, COL.DATA_PRECISION, CHAR_LENGTH) DATA_PRECISION"); // Oracle9i or Oracle10ĝ

		}

		sb.append("        ,COL.DATA_SCALE");
		sb.append("        ,COL.DATA_DEFAULT");
		sb.append("        ,COM.COMMENTS");
		sb.append("    FROM");
		sb.append("        ALL_TAB_COLUMNS COL");
		sb.append("        ,ALL_COL_COMMENTS COM");
		sb.append("    WHERE");
		sb.append("        COL.OWNER = COM.OWNER");
		sb.append("        AND COL.TABLE_NAME = COM.TABLE_NAME");
		sb.append("        AND COL.COLUMN_NAME = COM.COLUMN_NAME");
		sb.append("        AND COL.OWNER = '" + SQLUtil.encodeQuotation(owner) + "'");
		sb.append("        AND COL.TABLE_NAME = '" + SQLUtil.encodeQuotation(table) + "'");
		sb.append("    ORDER BY");
		sb.append("        COL.COLUMN_ID");

		return sb.toString();
	}

}
