/*
 * 쐬: 2005/03/24
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ext.oracle.tablespace;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleColumnSizeUtil;
import zigen.plugin.db.ext.oracle.internal.OracleDbBlockSizeSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleTableColumnSearcher;
import zigen.plugin.db.ui.internal.Table;

/**
 * CalcTableSpaceNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/10/01 ZIGEN create.
 * 
 */
public class CalcTableSpace {

	/**
	 * ύX\vpeB calcurate\bhsOɒlSet邱
	 */
	int block_header = 100; // 100oCg

	double safeCoefficient = 1.2; // SW

	/**
	 * RXgN^Œlݒ肷vpeB
	 */
	private final long maxRecord; // R[h

	private final Table table; // Ώۃe[u

	private final String ownerName; // L

	private final String tableName; // e[u

	private final int pctFree; // pctfree

	/**
	 * DB_BLOCK_SIZE
	 */
	private int blockSize;

	/**
	 * vZʎ擾p(SWȂj
	 */
	private BigDecimal tableSpaceSize;

	/**
	 * vZʎ擾piSẂj
	 */
	private BigDecimal tableSpaceSafeSize;

	/**
	 * SW\̈̌ςTCY
	 * 
	 * @return tableSpaceSafeSize ߂܂B
	 */
	public BigDecimal getTableSpaceSafeSize() {
		return tableSpaceSafeSize;
	}

	/**
	 * \̈̌ςTCY
	 * 
	 * @return tableSpaceSize ߂܂B
	 */
	public BigDecimal getTableSpaceSize() {
		return tableSpaceSize;
	}

	/**
	 * RXgN^
	 * 
	 * @param table
	 * @param pctFree
	 * @param maxRecord
	 */
	public CalcTableSpace(Table table, int pctFree, long maxRecord) {
		this.table = table;
		this.pctFree = pctFree;
		this.ownerName = table.getSchemaName();
		this.tableName = table.getName();
		this.maxRecord = maxRecord;
	}

	/**
	 * RXgN^
	 * 
	 * @param table
	 * @param pctFree
	 * @param maxRecord
	 */
	public CalcTableSpace(Table table, int blockSize, int pctFree, long maxRecord) {
		this.table = table;
		this.blockSize = blockSize;
		this.pctFree = pctFree;
		this.ownerName = table.getSchemaName();
		this.tableName = table.getName();
		this.maxRecord = maxRecord;
	}

	/**
	 * vZ\bh
	 */
	public void calcurate() throws CalcTableSpaceException {
		try {
			IDBConfig config = table.getDbConfig();
			Connection con = Transaction.getInstance(config).getConnection();

			// ubNTCYZo
			if (blockSize == 0) {
				blockSize = OracleDbBlockSizeSearcher.execute(con);
			}
//			log.debug("ubNTCY:" + this.blockSize); //$NON-NLS-1$

			// KvBlock
			double necessaryBlock = getNecessaryBlockSize(con, maxRecord);

			// KB, MB̔
			// log.debug("\̈̃TCYF" + tableSpaceSize);

			// SWȂ
			// this.tableSpaceSize = new BigDecimal((getNecessaryBlockSize(con,
			// maxRecord) * blockSize) / (1024d * 1024d));
			this.tableSpaceSize = new BigDecimal((necessaryBlock * blockSize) / (1024d * 1024d));

			// ؂グ
			// this.tableSpaceSize = this.tableSpaceSize.setScale(1,
			// BigDecimal.ROUND_UP); // ؏グ
			this.tableSpaceSize = this.tableSpaceSize.setScale(3, BigDecimal.ROUND_UP); // ؏グ

			// SW
			this.tableSpaceSafeSize = tableSpaceSize.multiply(new BigDecimal(safeCoefficient));
			// ؂グ
			// this.tableSpaceSafeSize = this.tableSpaceSafeSize.setScale(1,
			// BigDecimal.ROUND_UP); // ؏グ
			this.tableSpaceSafeSize = this.tableSpaceSafeSize.setScale(3, BigDecimal.ROUND_UP); // ؏グ

//			log.debug("KvȃTCY(MB)擾:" + tableSpaceSafeSize); //$NON-NLS-1$

		} catch (CalcTableSpaceException e) {
			throw e;

		} catch (Exception e) {
			throw new CalcTableSpaceException("\̈̌ς菈ŃG[܂", e.getCause()); //$NON-NLS-1$

		}

	}

	/**
	 * 1.ubNwb_[̈̎擾
	 * 
	 * @return
	 */
	public int getBlockHeaderSize() {
//		log.debug("1.ubNwb_[̈̎擾:" + this.block_header); //$NON-NLS-1$
		return this.block_header;
	}

	/**
	 * 2.p\̈̎擾
	 * 
	 * @return
	 */
	private final double getRiyouKanouArea() {
		double d = Math.ceil((blockSize - this.getBlockHeaderSize()) * (1 - pctFree / 100d));
//		log.debug("2.p\̈̎擾:" + d); //$NON-NLS-1$
		return d;

	}

	/**
	 * 3.ύsTCY̎擾
	 * 
	 * @return
	 */
	private final int getRowLength(Connection con) {
		int columnAreaSize = -1;
		try {

			// RowLength擾邾Ȃ̂ŁAconvertUnicodefalseŒ
			boolean convertUnicode = false;

			OracleTableColumn[] columns = OracleTableColumnSearcher.execute(con, table, convertUnicode);

			// J̈̎擾
			OracleColumnSizeUtil cs = new OracleColumnSizeUtil();
			columnAreaSize = cs.getRowLength(con, columns);

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);
		}

//		log.debug("3.ύsTCY̎擾:" + columnAreaSize); //$NON-NLS-1$
		return columnAreaSize;
	}

	/**
	 * 4.ubN̕ύšvZ
	 * 
	 * @return
	 */
	private final double getAverageRowCountOfBlock(Connection con) throws CalcTableSpaceException {
		// double d = Math.floor(getRiyouKanouArea() / getRowLength(con));

		// modify start 2006/09/23 p\̈̕ꍇl ZIGEN
		double d = 0.0d;
		double riyoukanou = getRiyouKanouArea();
		double rowLen = getRowLength(con);

		if (riyoukanou >= rowLen) {
			// ؎̂
			d = Math.floor(riyoukanou / rowLen); // ʏ͗p\̈̕傫
		} else {
			// p\̈̕ꍇ̏ǉ
			d = 1.0d / Math.ceil(rowLen / riyoukanou);

		}
		// modify end
//		log.debug("4.ubN̕ύšvZ:" + d); //$NON-NLS-1$
		return d;
	}

	/**
	 * KvȃubN
	 * 
	 * @param totalRow
	 * @return
	 */
	private final double getNecessaryBlockSize(Connection con, long totalRow) throws CalcTableSpaceException {
		double d = Math.ceil(totalRow / getAverageRowCountOfBlock(con));
//		log.debug("5.KvȃubN:" + d); //$NON-NLS-1$
		return d;
	}

	/**
	 * @param block_header
	 *            block_header ݒB
	 */
	public void setBlock_header(int block_header) {
		this.block_header = block_header;
	}

	/**
	 * @param blockSize
	 *            blockSize ݒB
	 */
	public void setBlockSize(int blockSize) {
		this.blockSize = blockSize;
	}

	/**
	 * @param safeCoefficient
	 *            safeCoefficient ݒB
	 */
	public void setSafeCoefficient(double safeCoefficient) {
		this.safeCoefficient = safeCoefficient;
	}

	/**
	 * @return safeCoefficient ߂܂B
	 */
	public double getSafeCoefficient() {
		return safeCoefficient;
	}

	/**
	 * @return blockSize ߂܂B
	 */
	public int getBlockSize() {
		return blockSize;
	}

	public String getCalcResult() throws Exception {
		StringBuffer sb = new StringBuffer();
		sb.append(" [e[ü]:" + tableName + " "); //$NON-NLS-1$ //$NON-NLS-2$
		sb.append("\n"); //$NON-NLS-1$
		sb.append("   ςTCY:"); //$NON-NLS-1$
		sb.append("  " + getTableSpaceSize() + " MB"); //$NON-NLS-1$ //$NON-NLS-2$
		sb.append("\n"); //$NON-NLS-1$
		sb.append("   ςTCY~" + getSafeCoefficient() + ":"); //$NON-NLS-1$ //$NON-NLS-2$
		sb.append("  " + getTableSpaceSafeSize() + " MB"); //$NON-NLS-1$ //$NON-NLS-2$
		sb.append("\n"); //$NON-NLS-1$
		return sb.toString();
	}

	public List getCsvRow() {
		List list = new ArrayList();
		
		list.add(ownerName);
		list.add(tableName);
		list.add(""); // Index //$NON-NLS-1$

		list.add(String.valueOf(blockSize));
		list.add(String.valueOf(pctFree));

		list.add(String.valueOf(maxRecord));
		list.add(String.valueOf(tableSpaceSize));
		list.add(String.valueOf(safeCoefficient));
		list.add(String.valueOf(tableSpaceSafeSize));
		return list;
	}

	public String csvString() {
		StringBuffer sb = new StringBuffer();
		sb.append(ownerName);
		sb.append(","); //$NON-NLS-1$
		sb.append(tableName);
		sb.append(","); //$NON-NLS-1$
		sb.append(""); // indexName͂Ȃ //$NON-NLS-1$
		sb.append(","); //$NON-NLS-1$
		sb.append(maxRecord);
		sb.append(","); //$NON-NLS-1$
		sb.append(tableSpaceSize);
		sb.append(","); //$NON-NLS-1$
		sb.append(safeCoefficient);
		sb.append(","); //$NON-NLS-1$
		sb.append(tableSpaceSafeSize);
		sb.append("\n"); //$NON-NLS-1$
		return sb.toString();
	}

	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("[CalcTableSpace:"); //$NON-NLS-1$
		buffer.append(" block_header: "); //$NON-NLS-1$
		buffer.append(block_header);
		buffer.append(" safeCoefficient: "); //$NON-NLS-1$
		buffer.append(safeCoefficient);
		buffer.append(" maxRecord: "); //$NON-NLS-1$
		buffer.append(maxRecord);
		buffer.append(" table: "); //$NON-NLS-1$
		buffer.append(table);
		buffer.append(" ownerName: "); //$NON-NLS-1$
		buffer.append(ownerName);
		buffer.append(" tableName: "); //$NON-NLS-1$
		buffer.append(tableName);
		buffer.append(" pctFree: "); //$NON-NLS-1$
		buffer.append(pctFree);
		buffer.append(" blockSize: "); //$NON-NLS-1$
		buffer.append(blockSize);
		buffer.append(" tableSpaceSize: "); //$NON-NLS-1$
		buffer.append(tableSpaceSize);
		buffer.append(" tableSpaceSafeSize: "); //$NON-NLS-1$
		buffer.append(tableSpaceSafeSize);
		buffer.append("]"); //$NON-NLS-1$
		return buffer.toString();
	}
}
