package zigen.plugin.db.preference;

import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;

import zigen.plugin.db.DbPluginFormatRule;

public class SQLTemplatesPreferencePage extends TemplatePreferencePage implements IWorkbenchPreferencePage{

	public static final String DESC = Messages.getString("SQLTemplatesPreferencePage.0"); //$NON-NLS-1$

	public SQLTemplatesPreferencePage() {
		setPreferenceStore(SQLTemplateEditorUI.getDefault().getPreferenceStore());
		setTemplateStore(SQLTemplateEditorUI.getDefault().getTemplateStore());
		setContextTypeRegistry(SQLTemplateEditorUI.getDefault().getContextTypeRegistry());
		super.setDescription(DESC);
		super.setTitle(Messages.getString("SQLTemplatesPreferencePage.1")); //$NON-NLS-1$
	}

	protected boolean isShowFormatterSetting() {
		return false;
	}

	public boolean performOk() {
		boolean ok = super.performOk();
		SQLTemplateEditorUI.getDefault().savePluginPreferences();
		return ok;
	}
}
