/*
 * 쐬: 2005/03/12
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

/**
 * ExecuteQueryActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [001] 2005/03/12 ZIGEN create.
 *        [002] 2005/06/02 ZIGEN ;/ tŁAs{^ꍇz
 * 
 */
public class ExecuteSQLAction extends AbstractExecuteSQLAction implements Runnable {

	/**
	 * RXgN^
	 * 
	 * @param viewer
	 */
	public ExecuteSQLAction(IDBConfig config, SQLSourceViewer viewer, String secondaryId) {
		super(config, viewer, secondaryId);
		this.setText(Messages.getString("ExecuteSQLAction.ExecuteAllSQL")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("ExecuteSQLAction.ExecuteAllSQLToolTip")); //$NON-NLS-1$
		this.setActionDefinitionId("zigen.plugin.SQLExecuteActionCommand"); //$NON-NLS-1$
	}

	public void run() {
		try {
			executeSql(getAllSql());

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);

		}
	}

}
