/*
 * 쐬: 2005/03/12
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFCommon Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/cpl-v10.html
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.StatusChangeListener;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.dialogs.DBConfigWizard;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.views.TreeContentProvider;

/**
 * RegistDBActionNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/12 ZIGEN create.
 * 
 */
public class RegistDBAction extends Action implements Runnable {
	TreeViewer viewer = null;

	/**
	 * RXgN^
	 * 
	 * @param viewer
	 */
	public RegistDBAction(TreeViewer viewer) {
		this.viewer = viewer;
		this.setText(Messages.getString("RegistDBAction.0")); //$NON-NLS-1$
		this.setToolTipText(Messages.getString("RegistDBAction.1")); //$NON-NLS-1$

		this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor(DbPlugin.IMG_CODE_DB_ADD));

	}

	/**
	 * Actions̏
	 */
	public void run() {

		Shell shell = DbPlugin.getDefault().getShell();
		DBConfigWizard wizard = new DBConfigWizard(viewer.getSelection());
		WizardDialog dialog2 = new WizardDialog(shell, wizard);
		int ret = dialog2.open();

		if (ret == IDialogConstants.OK_ID) {
			// XMLɕۑDBConfig擾
			IDBConfig newConfig = wizard.getNewConfig();

			// IContentProvider擾
			IContentProvider obj = viewer.getContentProvider();
			if (obj instanceof TreeContentProvider) {
				TreeContentProvider provider = (TreeContentProvider) obj;
				provider.addDataBase(newConfig); // f[^x[Xǉ

				// ǉ 2007/11/22(o^vfɃtH[JX^)
				Root root = provider.getRoot();
				viewer.expandToLevel(root, 1);
				TreeLeaf db = root.getChild(newConfig.getDbName());
				viewer.reveal(db);
				
				viewer.refresh();
			}

			// IԂēxʒm
			viewer.getControl().notifyListeners(SWT.Selection, null);
			
			
			StatusChangeListener.fireStatusChangeListener(viewer, StatusChangeListener.EVT_UpdateDataBaseList);
		}


	}

}
