package zigen.plugin.db.ui.contentassist.processor;

import java.util.List;

import kry.sql.tokenizer.TokenUtil;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.contentassist.ContentInfo;
import zigen.plugin.db.ui.contentassist.ProcessorInfo;
import zigen.plugin.db.ui.contentassist.SQLProposalCreator2;
import zigen.sql.parser.SqlParser;
import zigen.sql.parser.ast.ASTDeleteStatement;
import zigen.sql.parser.ast.ASTDropStatement;
import zigen.sql.parser.ast.ASTFromList;

public class DropProcessor extends DefaultProcessor {

	public DropProcessor(List proposals, ProcessorInfo info) {
		super(proposals, info);
	}

	public void createProposals(ASTDropStatement st) {

		String[] modifiers = rule.getKeywordNames();
		try {
			ContentInfo ci = new ContentInfo(ContentAssistUtil.getIDBConfig());

			if (ci.isConnected()) {

				TableInfo[] tinfos = ci.getTableInfo(); // e[u񃊃Xg擾

				switch (currentScope) {
				case SqlParser.SCOPE_DROP:
					// DeletêƂ́AFrom̂ݕ\
					modifiers = new String[] {
							"TABLE", //$NON-NLS-1$
							"VIEW", //$NON-NLS-1$
							"SYNONYM" //$NON-NLS-1$
					};
					
					break;

				case SqlParser.SCOPE_TARGET:
					// e[uXg\
					SQLProposalCreator2.addProposal(proposals, tinfos, pinfo);
					break;
				}

			}

		} catch (Exception e) {
			DbPlugin.getDefault().showErrorDialog(e);

		} finally {
			// SQLL[[h̓o^
			SQLProposalCreator2.addProposal(proposals, modifiers, pinfo);
		}

	}

}
