package zigen.plugin.db.ui.editors.sql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.PropertyPageChangeListener;
import zigen.plugin.db.StatusChangeListener;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.preference.SQLEditorPreferencePage;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.util.ResourceUtil;
import zigen.plugin.db.ui.util.StyledTextUtil;
import zigen.plugin.db.ui.views.CommitModeAction;
import zigen.plugin.db.ui.views.ISQLOperationTarget;
import zigen.plugin.db.ui.views.IStatusChangeListener;
import zigen.plugin.db.ui.views.TreeContentProvider;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.SQLCharacterPairMatcher;
import zigen.plugin.db.ui.views.internal.SQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.SQLPartitionScanner;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;
import zigen.plugin.db.ui.views.internal.SQLToolBar;

public class SqlEditor extends TextEditor implements IPropertyChangeListener, IStatusChangeListener, IPropertyPageChangeListener {

	protected SQLSourceViewer sqlViewer;

	protected SQLCodeConfiguration sqlConfiguration;

	protected IFile file;

	protected ColorManager colorManager;

	protected LineNumberRulerColumn rulerCol;

	protected IPreferenceStore store;

	protected ProjectionSupport projectionSupport;

//	protected IDBConfig config;

//	protected IDBConfig[] configs;

	protected Map fGlobalActions = new HashMap();

	protected SQLToolBar toolBar;
	
	
	public SqlEditor() {
		super();
		colorManager = new ColorManager();
		sqlConfiguration = new SQLCodeConfiguration(colorManager);
		setSourceViewerConfiguration(sqlConfiguration);
		this.store = DbPlugin.getDefault().getPreferenceStore();
		this.store.addPropertyChangeListener(this);
		StatusChangeListener.addStatusChangeListener(this);
		PropertyPageChangeListener.addPropertyPageChangeListener(this);
	}

	public void propertyPageChanged(Object obj, int status) {
		if (status == PropertyPageChangeListener.EVT_SetDataBase) {
			IDBConfig config = ResourceUtil.getDBConfig(file);
			toolBar.updateCombo(config);
		}
	}

	/**
	 * EditoN̏
	 */
	public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
		setSite(site);
		setInput(editorInput);
		if (editorInput instanceof FileEditorInput) {
			FileEditorInput fi = (FileEditorInput) editorInput;
			file = fi.getFile();
			//config = ResourceUtil.getDBConfig(file);
		}
	}

	public void createPartControl(Composite parent) {
		super.createPartControl(parent);

		sqlViewer = (SQLSourceViewer) getSourceViewer();
		//sqlViewer.setDbConfig(config); // DBConfigݒ肷
		
		
		IDocument doc = sqlViewer.getDocument();
		IDocumentPartitioner partitioner = new FastPartitioner(new SQLPartitionScanner(), new String[] { SQLPartitionScanner.SQL_STRING, SQLPartitionScanner.SQL_COMMENT });
		partitioner.connect(doc);
		doc.setDocumentPartitioner(partitioner);

		// Exception in thread "Thread-2" org.eclipse.swt.SWTError: Cannot
		// initialize Drop
		// 邽߁Aȉ̏̓RgƂ
		// DropTarget target = new DropTarget(sqlViewer.getTextWidget(),
		// DND.DROP_DEFAULT | DND.DROP_COPY | DND.DROP_MOVE | DND.DROP_LINK);
		// Transfer[] types = new Transfer[] {
		// TreeLeafListTransfer.getInstance(),
		// TextTransfer.getInstance(), FileTransfer.getInstance() };
		// target.setTransfer(types);
		// target.addDropListener(new DropTreeLeafAdapter(sqlViewer));

		ITextViewerExtension2 extension = (ITextViewerExtension2) sqlViewer;
		MatchingCharacterPainter painter = new MatchingCharacterPainter(sqlViewer, new SQLCharacterPairMatcher());
		painter.setColor(colorManager.getColor(SQLEditorPreferencePage.P_COLOR_MATCHING));
		extension.addPainter(painter);

		ProjectionViewer pviewer = (ProjectionViewer) getSourceViewer();
		projectionSupport = new ProjectionSupport(pviewer, getAnnotationAccess(), getSharedColors());
		projectionSupport.install();
		pviewer.doOperation(ProjectionViewer.TOGGLE);
		updateFolding();

		// getSite().setSelectionProvider(sqlViewer);
		// getEditorSite().getPage().addSelectionListener(this);

		StyledTextUtil.changeColor(colorManager, sqlViewer.getTextWidget());

		// |bvAbvj[쐬
		hookContextMenu();

		// Xe[^Xo[쐬
		// contributeToStatusLine();

		toolBar.setSQLSourceViewer(sqlViewer);

		// vWFNgɓo^Ăڑlł
		toolBar.updateCombo(ResourceUtil.getDBConfig(file));
	}

	protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {

		// Composite header = new Composite(parent, SWT.NONE);
		FormLayout layout = new FormLayout();
		parent.setLayout(layout);
		//createToolbarPart(parent);
		toolBar = new SQLToolBar(parent, this);
		
		Composite sqlComposite = new Composite(parent, SWT.NONE);
		sqlComposite.setLayout(new FillLayout());
		FormData data = new FormData();
		data.top = new FormAttachment(toolBar.getCoolBar(), 0);
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.bottom = new FormAttachment(100, 0);
		sqlComposite.setLayoutData(data);

		fAnnotationAccess = getAnnotationAccess();
		fOverviewRuler = createOverviewRuler(getSharedColors());
		// ISourceViewer viewer = new SQLSourceViewer(parent, ruler,
		// getOverviewRuler(), isOverviewRulerVisible(), styles);
		ISourceViewer viewer = new SQLSourceViewer(sqlComposite, ruler, getOverviewRuler(), true, styles);
		getSourceViewerDecorationSupport(viewer);

		return viewer;
	}

	private void hookContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				getContributor().fillContextMenu(manager);
			}
		});
		// SourceViewerւ̊蓖ẮATextWidgetɑ΂čs
		StyledText text = sqlViewer.getTextWidget();
		Menu menu = menuMgr.createContextMenu(text);
		text.setMenu(menu);
		getSite().registerContextMenu(menuMgr, sqlViewer);
	}

	private SqlEditorContributor getContributor() {
		IEditorActionBarContributor contributor = getEditorSite().getActionBarContributor();
		if (contributor instanceof SqlEditorContributor) {
			return (SqlEditorContributor) contributor;
		} else {
			return null;
		}
	}

	public String getEditingSource() {
		return getSourceViewer().getDocument().get();
	}

	protected IStatusLineManager getIStatusLineManager() {
		IEditorSite site = super.getEditorSite();
		IActionBars actionBars = site.getActionBars();
		return actionBars.getStatusLineManager();
	}

//	private boolean hasContributionItem(IContributionItem[] items, String targetId) {
//		for (int i = 0; i < items.length; i++) {
//			IContributionItem item = items[i];
//			if (targetId.equals(item.getId())) {
//				return true;
//			}
//		}
//		return false;
//	}

	// public void contributeToStatusLine() {
	// IStatusLineManager manager = getIStatusLineManager();
	// IContributionItem[] items = manager.getItems();
	// String commitMode = Messages.getString("SqlEditor.1"); //$NON-NLS-1$
	// if (!hasContributionItem(items, commitMode)) {
	// commitModeItem = new StatusLineContributionItem(commitMode);
	// commitModeItem.setText(Messages.getString("SqlEditor.2")); //$NON-NLS-1$
	// manager.add(commitModeItem);
	// }
	// }

	public void dispose() {
		colorManager.dispose();
		// getEditorSite().getPage().removeSelectionListener(this);
		DbPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this);
		StatusChangeListener.removeStatusChangeListener(this);
		PropertyPageChangeListener.removePropertyPageChangeListener(this);
		super.dispose();
	}

	public void propertyChange(PropertyChangeEvent event) {
		if (sqlConfiguration != null && sqlViewer != null) {
			sqlConfiguration.updatePreferences(sqlViewer.getDocument());
			StyledTextUtil.changeColor(colorManager, sqlViewer.getTextWidget());
			// LineNumberRulerColumnUtil.changeColor(colorManager, rulerCol);
			sqlViewer.invalidateTextPresentation();// eLXgGfB^ĕ`
		}
	}

	protected void setGlobalAction() {
		IActionBars actionBars = getEditorSite().getActionBars();
		actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.UNDO));
		actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.REDO));
		actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.DELETE));
		actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.SELECT_ALL));
		actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.COPY));
		actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.PASTE));
		actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), new GlobalAction(sqlViewer, ITextOperationTarget.CUT));

		setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLExecuteAction", new GlobalAction(sqlViewer, ISQLOperationTarget.ALL_EXECUTE)); //$NON-NLS-1$
		setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLCurrentExecuteAction", new GlobalAction(sqlViewer, ISQLOperationTarget.CURRENT_EXECUTE)); //$NON-NLS-1$
		setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLSelectedExecuteAction", new GlobalAction(sqlViewer, ISQLOperationTarget.SELECTED_EXECUTE)); //$NON-NLS-1$

	}

	protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
		fGlobalActions.put(actionID, action);
		actionBars.setGlobalActionHandler(actionID, action);
	}

	public void setFocus() {
		setGlobalAction();
	}

	public IDBConfig getConfig() {
		return toolBar.getConfig();
	}

	public Object getAdapter(Class adapter) {
		if (projectionSupport != null) {
			Object obj = projectionSupport.getAdapter(getSourceViewer(), adapter);
			if (obj != null) {
				return obj;
			}
		}
		return super.getAdapter(adapter);
	}

	protected void updateFolding() {
		sqlViewer.updateFolding();

	}

	public void doSave(IProgressMonitor progressMonitor) {
		super.doSave(progressMonitor);
		updateFolding();
	}

	public void doSaveAs() {
		super.doSaveAs();
		updateFolding();
	}

	
//	protected void handleCursorPositionChanged() {
//	    super.handleCursorPositionChanged();
////	    updateStatusField("categoryName");
//	}

	
	public void statusChanged(Object obj, int status) {
		if (obj instanceof CommitModeAction) {
			CommitModeAction action = (CommitModeAction) obj;
			switch (status) {
			case StatusChangeListener.EVT_ChangeTransactionMode: // R~bg[hύX
				toolBar.setCommitMode(action.getDbConfig(), action.isAutoCommit());
				break;
			default:
				break;
			}
		}

		if (status == StatusChangeListener.EVT_UpdateDataBaseList) {
			toolBar.initializeSelectCombo();
		}
		
	}

	class SaveAction extends org.eclipse.jface.action.Action {
		public SaveAction() {
			this.setToolTipText("Save"); //$NON-NLS-1$
			this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor(DbPlugin.IMG_CODE_SAVE));
		}

		public void run() {
			doSave(null);
		}

	}

}
