package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import java.text.NumberFormat;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.ConnectionManager;
import zigen.plugin.db.core.TableManager;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.preference.PreferencePage;
import zigen.plugin.db.ui.actions.ConfirmConnectDBAction;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.TableViewEditorInput;
import zigen.plugin.db.ui.internal.ITable;

public class RecordCountForTableJob extends AbstractJob {

	private Transaction trans;

	private ITable table;

	int dispCount; // \

	String condition;

	public RecordCountForTableJob(Transaction trans, ITable table, String condition, int dispCount) {
		super(Messages.getString("RecordCountForTableJob.0")); //$NON-NLS-1$
		this.trans = trans;
		this.table = table;
		this.condition = condition;
		this.dispCount = dispCount;
	}

	protected IStatus run(IProgressMonitor monitor) {
		Connection con = null; // R[h͓Ǝ̃RlNVg
		try {
			start();
			if (!trans.isConneting()) {
				Display.getDefault().syncExec(new ConfirmConnectDBAction(trans));
				if (!trans.isConneting()) {
					showWarningMessage(DbPluginConstant.MSG_NO_CONNECTED_DB);
					return Status.CANCEL_STATUS;
				}
			}

			if (monitor.isCanceled()) {
				return Status.CANCEL_STATUS;
			}

			int timeout = store.getInt(PreferencePage.P_QUERY_TIMEOUT_FOR_COUNT);
			String sqlString = TableManager.getSQL(table, condition, 0); // JEgꍇLimit0ōsȂ
			TotalRecordCountSearchThread t = new TotalRecordCountSearchThread(trans, sqlString, timeout);
			Thread th = new Thread(t);
			th.start();

			if (timeout > 0) {
				th.join(timeout * 1000);
			}else{
				th.join();
			}
			if (monitor.isCanceled()) {
				return Status.CANCEL_STATUS;
			}
			if (t.isComplete) {
				showResults(new SetTotalCountAction(t.count));
			} else {
				showResults(new SetTotalCountAction(-1));
			}
			return Status.OK_STATUS;

		} catch (Exception e) {
			DbPlugin.log(e);
			showResults(new SetTotalCountAction(-1)); // R[h\Ȃ

		} finally {
			stop();
			ConnectionManager.closeConnection(con);
		}
		return Status.OK_STATUS;

	}

	protected class SetTotalCountAction implements Runnable {
		long count;

		public SetTotalCountAction(long count) {
			this.count = count;
		}

		public void run() {
			try {
				NumberFormat format = NumberFormat.getInstance();
				String totalCount = format.format(count);

				String displayCount = format.format(dispCount);

				IWorkbenchPage page = DbPlugin.getDefault().getPage();
				TableViewEditorInput input = new TableViewEditorInput(trans.getConfig(), table);

				IEditorPart editor = DbPlugin.getDefault().getPage().findEditor(input);
				if (editor instanceof TableViewEditorFor31) {
					TableViewEditorFor31 tEditor = (TableViewEditorFor31) editor;
					tEditor.setTotalCount(displayCount, totalCount);
				} else {
					DbPlugin.log("A corresponding editor is not found.");
				}
			} catch (Exception e) {
				DbPlugin.log(e);
			}

		}
	}
}
