package zigen.plugin.db.ui.jobs;

import java.sql.SQLException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableManager;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.ui.actions.MaxRecordException;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.internal.ITable;

public class RecordSearchJob extends AbstractJob {


	public static final String JOB_NAME = RecordSearchJob.class.getName();

	private TableViewEditorFor31 editor;

	private String condition;

	private String orderBy;
	
	public RecordSearchJob(TableViewEditorFor31 editor, String condition, String orderBy) {
		super(Messages.getString("RecordSearchJob.0")); //$NON-NLS-1$
		this.editor = editor;
		this.condition = condition;
		this.orderBy = orderBy;
	}

	protected IStatus run(IProgressMonitor monitor) {
		TableElement[] elements = null;

		TimeWatcher time = new TimeWatcher();
		time.start();

		try {
			start();

			ITable table = editor.getTableNode();
			if(orderBy != null){
				if(condition == null){
					elements = TableManager.invoke(table.getDbConfig(), table, orderBy);
				}else{
					elements = TableManager.invoke(table.getDbConfig(), table, condition + " " + orderBy);
				}
				
			}else{
				elements = TableManager.invoke(table.getDbConfig(), table, condition);
			}
			time.stop();
			if (monitor.isCanceled()) {
				return Status.CANCEL_STATUS;
			}
			// ʕ\
			showResults(new ShowResultAction(condition, elements, time.getTotalTime()));

		} catch (MaxRecordException e) {
			time.stop();
			elements = e.getTableElements();
			showResults(new ShowResultAction(condition, elements, time.getTotalTime(),e.getMessage()));
			//showWarningMessage(e.getMessage());

		} catch (SQLException e){
			showWarningMessage(e.getMessage());
			
		} catch (Exception e) {
			showErrorMessage(Messages.getString("RecordSearchJob.1"), e); //$NON-NLS-1$

		} finally {
			stop();
		}

		return Status.OK_STATUS;
	}

	protected class ShowResultAction implements Runnable {
		String condition = null;

		TableElement[] elements = null;

		String responseTime = null;
		
		String message = null;
		
		public ShowResultAction(String condition, TableElement[] elements, String responseTime, String message) {
			this.condition = condition;
			this.elements = elements;
			this.responseTime = responseTime;
			this.message = message;
		}
		public ShowResultAction(String condition, TableElement[] elements, String responseTime) {
			this(condition, elements, responseTime, "");
		}

		public void run() {
			try {
				editor.updateTableViewer(condition, elements, responseTime);
				editor.setInfomationText(message);
			} catch (Exception e) {
				DbPlugin.log(e);
			}

		}
	}

}
