/*
 * 쌠: Copyright (c) 2007|2008 ZIGEN
 * CZXFEclipse Public License - v 1.0 
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */

package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import zigen.plugin.db.DbPlugin;

/**
 * ConstraintSearcherNX.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/24 ZIGEN create.
 * 
 */
public class ConstraintSearcher {

	// INDEX  TYPEJŕԂ萔
	public static final int TABLE_INDEX_STATISTIC = 0; // CfbNX̓vlD

	public static final int TABLE_INDEX_CLSTERED = 1; // NX^[CfbNXD

	public static final int TABLE_INDEX_HASHED = 2; // nbVCfbNXD

	public static final int TABLE_INDEX_OTHER = 3; // LȊOCfbNXD

	private static String getIndexTypeName(int indexType) {
		switch (indexType) {
		case TABLE_INDEX_STATISTIC:
			return "TABLE_INDEX_STATISTIC"; //$NON-NLS-1$
		case TABLE_INDEX_CLSTERED:
			return "TABLE_INDEX_CLSTERED"; //$NON-NLS-1$
		case TABLE_INDEX_HASHED:
			return "TABLE_INDEX_HASHED"; //$NON-NLS-1$
		case TABLE_INDEX_OTHER:
			return "TABLE_INDEX_OTHER"; //$NON-NLS-1$
		default:
			return "TABLE_INDEX_UNKNOWN"; //$NON-NLS-1$
		}
	}

	/**
	 * w肵e[uPK擾
	 * 
	 * @param con
	 * @param catalog
	 * @param schemaPattern
	 * @return
	 */
	public static TablePKColumn[] getPKColumns(IDBConfig config, String schemaPattern, String tableName) throws Exception {
		try {
			Connection con = Transaction.getInstance(config).getConnection();
			return getPKColumns(con, schemaPattern, tableName);
		} catch (Exception e) {
			throw e;
		}
	}

	public static TablePKColumn[] getPKColumns(Connection con, String schemaPattern, String tableName) throws Exception {
		List list = new ArrayList();
		ResultSet rs = null;
		Statement st = null;
		try {
			DatabaseMetaData objMet = con.getMetaData();

			if(DBType.getType(objMet)==DBType.DB_TYPE_MYSQL
					&& objMet.getDatabaseMajorVersion() >= 5){
				st = con.createStatement();
				rs = st.executeQuery(getPrimaryKeys_MYSQL5(schemaPattern, tableName));
				
			}else{
				if (schemaPattern != null) {
					rs = objMet.getPrimaryKeys(null, schemaPattern, tableName);
				} else {
					rs = objMet.getPrimaryKeys(null, "%", tableName); //$NON-NLS-1$
				}

			}
			

			int i = 0;
			while (rs.next()) {
				i++;
				TablePKColumn column = new TablePKColumn();
				column.setSep(rs.getInt("KEY_SEQ")); //$NON-NLS-1$
				column.setColumnName(rs.getString("COLUMN_NAME")); //$NON-NLS-1$
				column.setName(rs.getString("PK_NAME")); //$NON-NLS-1$
				list.add(column);
			}

			Collections.sort(list, new ConstraintSeqSorter());

			return (TablePKColumn[]) list.toArray(new TablePKColumn[0]);

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		} finally {
			StatementUtil.close(st);
			ResultSetUtil.close(rs);
		}
	}
	
	private static String getPrimaryKeys_MYSQL5(String schemaPattern, String tableName){
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT");
		sb.append("        TABLE_SCHEMA AS TABLE_CAT");
		sb.append("        ,NULL AS TABLE_SCHEM");
		sb.append("        ,TABLE_NAME");
		sb.append("        ,COLUMN_NAME");
		sb.append("        ,SEQ_IN_INDEX AS KEY_SEQ");
		sb.append("        ,'PRIMARY' AS PK_NAME");
		sb.append("    FROM");
		sb.append("        INFORMATION_SCHEMA.STATISTICS");
		sb.append("    WHERE");
		sb.append("        INDEX_NAME = 'PRIMARY'");
		sb.append("        AND TABLE_SCHEMA = '"+SQLUtil.encodeQuotation(schemaPattern)+"'");
		sb.append("        AND TABLE_NAME = '"+SQLUtil.encodeQuotation(tableName)+"'");
		sb.append("    ORDER BY");
		sb.append("        TABLE_SCHEMA");
		sb.append("        ,TABLE_NAME");
		sb.append("        ,INDEX_NAME");
		sb.append("        ,SEQ_IN_INDEX");
		return sb.toString();

	}

	/**
	 * w肵e[uFK擾
	 * 
	 * @param con
	 * @param catalog
	 * @param schemaPattern
	 * @return
	 */
	public static TableFKColumn[] getFKColumns(IDBConfig config, String schemaPattern, String tableName) throws Exception {
		try {
			Connection con = Transaction.getInstance(config).getConnection();
			return getFKColumns(con, schemaPattern, tableName);

		} catch (Exception e) {
			throw e;
		}
	}

	public static TableFKColumn[] getFKColumns(Connection con, String schemaPattern, String tableName) throws Exception {
		List list = new ArrayList();
		ResultSet rs = null;
		try {
			DatabaseMetaData objMet = con.getMetaData();
			if (schemaPattern != null) {
				rs = objMet.getImportedKeys(null, schemaPattern, tableName);
			} else {
				rs = objMet.getImportedKeys(null, "%", tableName); //$NON-NLS-1$
			}

			while (rs.next()) {
				TableFKColumn column = new TableFKColumn();
				column.setSep(rs.getInt("KEY_SEQ")); //$NON-NLS-1$
				column.setColumnName(rs.getString("FKCOLUMN_NAME")); //$NON-NLS-1$
				column.setName(rs.getString("FK_NAME")); //$NON-NLS-1$
				column.setPkSchema(rs.getString("PKTABLE_SCHEM")); //$NON-NLS-1$
				column.setPkTableName(rs.getString("PKTABLE_NAME")); //$NON-NLS-1$
				column.setPkColumnName(rs.getString("PKCOLUMN_NAME")); //$NON-NLS-1$
				column.setPkName(rs.getString("PK_NAME")); //$NON-NLS-1$
				int delRule = rs.getInt("DELETE_RULE"); //$NON-NLS-1$
				if (delRule == 0) {
					column.setCasucade(true);
				} else {
					column.setCasucade(false);
				}
				list.add(column);
			}

			Collections.sort(list, new ConstraintSeqSorter());
			Collections.sort(list, new ConstraintNameSorter());

			return (TableFKColumn[]) list.toArray(new TableFKColumn[0]);

		} catch (SQLException e) {
			// T|[gp
			return new TableFKColumn[0];

		} catch (Exception e) {
			throw e;

		} finally {
			ResultSetUtil.close(rs);
		}
	}

	/**
	 * w肵JPKǂ
	 * 
	 * @param pks
	 * @param columnName
	 * @return
	 */
	public static boolean isPKColumn(TablePKColumn[] pks, String columnName) {
		if (pks == null)
			return false;
		for (int i = 0; i < pks.length; i++) {
			if (pks[i].getColumnName().equals(columnName)) {
				return true;
			}
		}
		return false;
	}

	public static TableIDXColumn[] getFirstUniqueIndex(TableIDXColumn[] indxs) {

		if (indxs != null && indxs.length > 0) {
			List result = new ArrayList(indxs.length);
			String constraintName = indxs[0].getName(); // ŏ̐񖼂gp

			for (int i = 0; i < indxs.length; i++) {
				TableIDXColumn indx = indxs[i];
				if (constraintName.equals(indx.getName())) {
					result.add(indx);
				} else {
					break;
				}
			}
			return (TableIDXColumn[]) result.toArray(new TableIDXColumn[0]);

		} else {
			return null;
		}

	}

	/**
	 * w肵Jj[NINDEXǂ
	 * 
	 * @param uniqueIndexs
	 * @param columnName
	 * @return
	 */
	public static boolean isUniqueIDXColumn(TableIDXColumn[] uniqueIndexs, String columnName) {
		if (uniqueIndexs == null) {
			return false;
		}
		for (int i = 0; i < uniqueIndexs.length; i++) {
			if (uniqueIndexs[i].getColumnName().equals(columnName)) {
				return !uniqueIndexs[i].isNonUnique();
			}
		}

		return false;
	}

	public static TableIDXColumn[] getUniqueIDXColumns(Connection con, String schemaPattern, String tableName, boolean unique) throws Exception {
		List list = new ArrayList();
		ResultSet rs = null;
		try {
			TimeWatcher tw = new TimeWatcher();
			tw.start();

			DatabaseMetaData objMet = con.getMetaData();
			if (schemaPattern != null) {
				rs = objMet.getIndexInfo(null, schemaPattern, tableName, unique, true);
			} else {
				rs = objMet.getIndexInfo(null, "%", tableName, unique, true); //$NON-NLS-1$
			}
			tw.stop();

			
//			if (log.isDebugEnabled()) {
//				log.debug("INDEXԁF" + tw.getTotalTime()); //$NON-NLS-1$
//			}

			while (rs.next()) {
				String indexName = rs.getString("INDEX_NAME"); //$NON-NLS-1$
				if (indexName != null) {
					TableIDXColumn column = new TableIDXColumn();
					column.setName(indexName);
					column.setOrdinal_position(rs.getInt("ORDINAL_POSITION")); //$NON-NLS-1$
					column.setColumnName(rs.getString("COLUMN_NAME")); //$NON-NLS-1$
					if (rs.getBoolean("NON_UNIQUE")) { //$NON-NLS-1$
						column.setNonUnique(true);
					} else {
						column.setNonUnique(false);
					}
					column.setIndexType(getIndexTypeName(rs.getInt("TYPE"))); //$NON-NLS-1$

					list.add(column);
				}

			}

			Collections.sort(list, new ConstraintSeqSorter());
			Collections.sort(list, new ConstraintNameSorter());

			return (TableIDXColumn[]) list.toArray(new TableIDXColumn[0]);

		} catch (SQLException e) {
			DbPlugin.log(e);
			return new TableIDXColumn[0];// T|[gp

		} catch (Exception e) {
			DbPlugin.log(e);
			throw e;

		} finally {
			ResultSetUtil.close(rs);
		}
	}

}
