/*
 * 쌠: Copyright (c) 2007|2008 ZIGEN
 * CZXFEclipse Public License - v 1.0 
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */

package zigen.plugin.db.core;

import java.io.Serializable;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.preference.PreferencePage;
import zigen.plugin.db.ui.internal.ITable;

/**
 * TableColumnNX. PR[h̃f[^ێNX
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/03/24 ZIGEN create.
 * 
 */
public class TableElement implements Serializable, Cloneable {
	protected ITable table; // e[uie[uĂꍇNULL)

	protected int recordNo; // R[hԍ

	protected TableColumn[] columns; // Jz

	protected Object[] items; // f[^z

	protected TableColumn[] uniqueColumns; // UniqueJz

	protected Object[] uniqueItems; // Uniquef[^z

	// IWif[^ۑp
	protected Object[] orgItems;

	// IvV
	protected List modifiedList = new ArrayList(); // ҏWĂJ

	protected boolean isNew = false; // VKR[hǂ

	protected boolean canModify = true; // ҏW\ǂ

	protected TablePKColumn[] pks;

	protected List fks;
	
	protected boolean updatedDataBase;

	
	public void copy(TableElement src){
		this.items = src.items;
		this.orgItems = src.orgItems;
	}
	
	
	public boolean hasTablePKColumn() {
		return (pks != null);
	}

	public boolean hasTableFKColumn() {
		return (fks != null);
	}

	public void setTablePKColumn(TablePKColumn[] pks) {
		this.pks = pks;
	}

	public void setTableFKColumn(TableFKColumn[] fks) {
		this.fks = convertTableFKColumn(fks);
	}

	public String getConstraintPKStr() {
		StringBuffer sb = new StringBuffer();

		if (pks == null || pks.length == 0)
			return null;

		int i = 0;
		for (i = 0; i < pks.length; i++) {

			TablePKColumn pkc = pks[i];
			if (i == 0) {
				sb.append("CONSTRAINT ");
				sb.append(pkc.getName());
				sb.append(" PRIMARY KEY ");
				sb.append("(");
				sb.append(pkc.getColumnName());
			} else {
				sb.append(", " + pkc.getColumnName());
			}

		}
		sb.append(")");
		return sb.toString();
	}

	public List convertTableFKColumn(TableFKColumn[] fks) {

		List result = new ArrayList();

		String temp = "";
		for (int i = 0; i < fks.length; i++) {

			TableFKColumn fkc = fks[i];
			temp = fkc.getName();
			List list = new ArrayList();

			for (int k = i; k < fks.length; k++) {
				TableFKColumn _fkc = fks[k];
				if (!temp.equals(_fkc.getName())) {
					break;
				} else {
					list.add(_fkc);
					i += k;
				}
				temp = _fkc.getName();
			}
			result.add((TableFKColumn[]) list.toArray(new TableFKColumn[0]));
		}

		return result;
	}

	public String[] getConstraintFKStr() {

		if (fks == null)
			return null;
		List result = new ArrayList();
		for (Iterator iter = fks.iterator(); iter.hasNext();) {
			TableFKColumn[] _fks = (TableFKColumn[]) iter.next();

			StringBuffer sb = new StringBuffer();
			StringBuffer sb2 = new StringBuffer();
			boolean cascade = false;
			for (int i = 0; i < _fks.length; i++) {
				TableFKColumn column = _fks[i];
				cascade = column.isCasucade();

				if (i == 0) {
					sb.append("CONSTRAINT ");
					sb.append(column.getName());
					sb.append(" FOREIGN KEY ");
					sb.append("(");
					sb.append(column.getColumnName());

					// Reference
					sb2.append(" REFERENCES ");
					if (column.getPkSchema() != null) {
						sb2.append(column.getPkSchema());
						sb2.append(".");
					}
					sb2.append(column.getPkTableName());
					sb2.append(" ");
					sb2.append("(");
					sb2.append(column.getPkColumnName());

				} else {

					sb.append(", " + column.getColumnName());
					sb2.append(", " + column.getColumnName());
				}

			}
			sb.append(")");
			sb2.append(")");
			if (cascade) {
				sb2.append(" ON DELETE CASCADE");
			}
			result.add(sb.toString() + sb2.toString());
		}

		return (String[]) result.toArray(new String[0]);

	}

	public void addMofiedColumn(int colIndex) {
		if (columns != null || colIndex <= columns.length - 1)
			if (!modifiedList.contains(columns[colIndex])) {
				this.modifiedList.add(columns[colIndex]);
			}
	}

	public boolean isModify() {
		return (modifiedList.size() > 0);
	}

	
	public boolean isNew() {
		return this.isNew;
	}

	public TableColumn[] getModifiedColumns() {
		return (TableColumn[]) this.modifiedList.toArray(new TableColumn[0]);
	}

	public Object[] getModifiedItems() {
		Object[] modifiedValues = new Object[modifiedList.size()];
		for (int i = 0; i < modifiedList.size(); i++) {
			modifiedValues[i] = getItem((TableColumn) modifiedList.get(i));
		}
		return modifiedValues;
	}

	/**
	 * w肵TableColumnItem擾
	 * 
	 * @param column
	 * @return
	 */
	public Object getItem(TableColumn column) {
		for (int i = 0; i < columns.length; i++) {
			if (columns[i].equals(column)) {
				return items[i];
			}
		}
		return null;
	}

	/**
	 * Querypp
	 */
	public TableElement(int recordNo, TableColumn[] columns, Object[] items) {
		this.recordNo = recordNo;
		this.columns = columns;
		this.items = items;
	}

	/**
	 * e[uҏWp
	 */
	public TableElement(ITable table, int recordNo, TableColumn[] columns, Object[] items, TableColumn[] uniqueColumns, Object[] uniqueItems) {
		this.table = table;
		this.recordNo = recordNo;
		this.columns = columns;
		this.items = items;

		this.uniqueColumns = uniqueColumns;
		this.uniqueItems = uniqueItems;

		// IWif[^Rs[Ă
		if (items != null) {
			this.orgItems = new Object[items.length];
			System.arraycopy(items, 0, this.orgItems, 0, items.length);
		}
	}

	/**
	 * @return columNo ߂܂B
	 */
	public int getRecordNo() {
		return recordNo;
	}

	/**
	 * @return items ߂܂B
	 */
	public Object[] getItems() {
		return items;
	}

	/**
	 * @return columns ߂܂B
	 */
	public TableColumn[] getColumns() {
		return columns;
	}

	/**
	 * @return uniqueColumns ߂܂B
	 */
	public TableColumn[] getUniqueColumns() {
		return uniqueColumns;
	}

	/**
	 * @return uniqueItems ߂܂B
	 */
	public Object[] getUniqueItems() {
		return uniqueItems;
	}

	private Object padding(int index, Object obj) {

		if (obj instanceof String) {
			String value = String.valueOf(obj);

			// NULLł΁Aȉ͍̏sȂ
			String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString(PreferencePage.P_NULL_SYMBOL);
			if (!value.equals(nullSymbol)) {
				TableColumn column = columns[index];
				int type = column.getDataType();
				int size = column.getColumnSize();
				switch (type) {
				case Types.CHAR:
					return StringUtil.padding(value, size);
				}
			}
		}

		return obj;
	}

	/**
	 * wJ̃IuWFNgXV
	 * 
	 * @param index
	 * @param obj
	 */
	public void updateItems(int index, Object obj) {

		// items[index] = obj;
		items[index] = padding(index, obj); // CHAR^pɋ󔒃pfBO

		// ύXXgɓo^io^ς݂̏ꍇ͓o^Ȃj
		addMofiedColumn(index);
	}

	public boolean isCanModify() {
		return canModify;
	}

	public void setCanModify(boolean canModify) {
		this.canModify = canModify;
	}

	public ITable getTable() {
		return table;
	}

	public void setTable(ITable table) {
		this.table = table;
	}

	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("[TableElement:");
		buffer.append(" table: ");
		buffer.append(table);
		buffer.append(" recordNo: ");
		buffer.append(recordNo);
		buffer.append(" { ");
		for (int i0 = 0; columns != null && i0 < columns.length; i0++) {
			buffer.append(" columns[" + i0 + "]: ");
			buffer.append(columns[i0]);
		}
		buffer.append(" } ");
		buffer.append(" { ");
		for (int i0 = 0; items != null && i0 < items.length; i0++) {
			buffer.append(" items[" + i0 + "]: ");
			buffer.append(items[i0]);
		}
		buffer.append(" } ");
		buffer.append(" { ");
		for (int i0 = 0; uniqueColumns != null && i0 < uniqueColumns.length; i0++) {
			buffer.append(" uniqueColumns[" + i0 + "]: ");
			buffer.append(uniqueColumns[i0]);
		}
		buffer.append(" } ");
		buffer.append(" { ");
		for (int i0 = 0; uniqueItems != null && i0 < uniqueItems.length; i0++) {
			buffer.append(" uniqueItems[" + i0 + "]: ");
			buffer.append(uniqueItems[i0]);
		}
		buffer.append(" } ");
		buffer.append(" modifiedList: ");
		buffer.append(modifiedList);
		buffer.append(" isNew: ");
		buffer.append(isNew);
		buffer.append(" canModify: ");
		buffer.append(canModify);
		buffer.append("]");
		return buffer.toString();
	}

	public Object[] getOrgItems() {
		return orgItems;
	}

	/**
	 * j[NL[ɑΉlXV܂
	 * 
	 */
	public void modifyUniqueItems() {
		Object[] uniequeItems = new Object[uniqueColumns.length];

		for (int i = 0; i < uniqueColumns.length; i++) {
			TableColumn uCol = uniqueColumns[i];

			for (int k = 0; k < columns.length; k++) {
				TableColumn col = columns[k];

				if (col.getColumnName().equals(uCol.getColumnName())) {
					uniequeItems[i] = items[k];
					break;
				}
			}
		}

		this.uniqueItems = uniequeItems;
	}
	

	/**
	 * isModifyZbg邽߂̃\bh
	 *
	 */
	public void clearMofiedColumn(){
		modifiedList = new ArrayList(); 
	}


	public boolean isUpdatedDataBase() {
		return updatedDataBase;
	}


	public void setUpdatedDataBase(boolean updatedDataBase) {
		this.updatedDataBase = updatedDataBase;
	}


	public void setRecordNo(int recordNo) {
		this.recordNo = recordNo;
	}


	public void isNew(boolean isNew) {
		this.isNew = isNew;
	}

}
