/*
 * 쌠: Copyright (c) 2007|2008 ZIGEN
 * CZXFEclipse Public License - v 1.0 
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */

package zigen.plugin.db.core.rule;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.sql.PreparedStatement;
import java.sql.Types;
import java.util.Map;
import java.util.TreeMap;

import zigen.plugin.db.DbPlugin;

/**
 * MySQLMappingFactory.java.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/11/26 ZIGEN create.
 * 
 */
public class MySQLMappingFactory extends DefaultMappingFactory implements IMappingFactory {

	MySQLMappingFactory(boolean convertUnicode) {
		super(convertUnicode);
	}

	protected void setBinary(PreparedStatement pst, int icol, Object value) throws Exception {
		if (value == null) {
			pst.setNull(icol, Types.BLOB);
			return;

		} else {
			int size = 0;
			try {
				if (value instanceof File) {
					File file = (File) value;
					size = (int) file.length();
					pst.setBinaryStream(icol, new FileInputStream(file), (int) size);

				} else if (value instanceof byte[]) {
					byte[] bytes = (byte[]) value;
					size = bytes.length;
					pst.setBinaryStream(icol, new ByteArrayInputStream(bytes), (int) size);

				} else if (value instanceof String) {
					String str = (String) value;
					if (nullSymbol.equals(str)) {
						pst.setNull(icol, Types.BLOB);
						return;
					} else {
						byte[] bytes = str.getBytes();
						size = bytes.length;
						pst.setBinaryStream(icol, new ByteArrayInputStream(bytes), (int) size);
					}
				}

			} catch (Exception e) {
				DbPlugin.log(e);

			}

		}
	}
	
	static Map typeMap = new TreeMap();
	
	static {
		typeMap.put("BIT", new Integer(Types.BIT));
		typeMap.put("TINYINT", new Integer(Types.TINYINT));
		typeMap.put("SMALLINT", new Integer(Types.SMALLINT));
		typeMap.put("MEDIUMINT", new Integer(Types.INTEGER));
		typeMap.put("INT", new Integer(Types.INTEGER));
		typeMap.put("INTEGER", new Integer(Types.INTEGER));
		typeMap.put("BIGINT", new Integer(Types.BIGINT));
		typeMap.put("INT24", new Integer(Types.INTEGER));
		typeMap.put("REAL",  new Integer(Types.DOUBLE));
		typeMap.put("FLOAT",  new Integer(Types.REAL));
		typeMap.put("DECIMAL",  new Integer(Types.DECIMAL));
		typeMap.put("NUMERIC",  new Integer(Types.DECIMAL));
		typeMap.put("DOUBLE",  new Integer(Types.DOUBLE));
		typeMap.put("CHAR",  new Integer(Types.CHAR));
		typeMap.put("VARCHAR",  new Integer(Types.VARCHAR));
		typeMap.put("DATE",  new Integer(Types.DATE));
		typeMap.put("TIME",  new Integer(Types.TIME));
		typeMap.put("YEAR",  new Integer(Types.DATE));
		typeMap.put("TIMESTAMP",  new Integer(Types.TIMESTAMP));
		typeMap.put("DATETIME",  new Integer(Types.TIMESTAMP));
		typeMap.put("TINYBLOB", new Integer(Types.BINARY));
		typeMap.put("BLOB", new Integer(Types.LONGVARBINARY));
		typeMap.put("MEDIUMBLOB", new Integer(Types.LONGVARBINARY));
		typeMap.put("LONGBLOB", new Integer(Types.LONGVARBINARY));
		typeMap.put("TINYTEXT", new Integer(Types.VARCHAR));
		typeMap.put("TEXT", new Integer(Types.LONGVARCHAR));
		typeMap.put("MEDIUMTEXT", new Integer(Types.LONGVARCHAR));
		typeMap.put("LONGTEXT", new Integer(Types.LONGVARCHAR));
		typeMap.put("ENUM",  new Integer(Types.CHAR));
		typeMap.put("SET",  new Integer(Types.CHAR));
		typeMap.put("GEOMETRY",  new Integer(Types.BINARY));
	}
	
	public int getJavaType(String typeName){
		String key = typeName.toUpperCase();
		if(typeMap.containsKey(key)){
			Integer i = (Integer)typeMap.get(key);
			return i.intValue();
		}else{
			return java.sql.Types.OTHER;
		}
	}

}
