/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kry.sql.format.SqlFormatRule;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import zigen.plugin.db.DbPluginFormatRule;
import zigen.plugin.db.IStatusChangeListener;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.JobException;
import zigen.plugin.db.Messages;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.XmlController;
import zigen.plugin.db.core.ConditionManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.ui.bookmark.BookmarkManager;
import zigen.plugin.db.ui.dialogs.DBDialogSettings;
import zigen.plugin.db.ui.dialogs.IDBDialogSettings;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.views.TreeContentProvider;
import zigen.plugin.db.ui.views.TreeView;

public class DbPlugin
extends AbstractUIPlugin {
    private static DbPlugin plugin;
    private ResourceBundle resourceBundle;
    private IDBDialogSettings dBDialogSettings;
    private XmlController xmlController;
    private String defaultProject = null;
    private ImageCacher imageCacher;
    private String defaultSaveDir = null;
    private static List listeners;
    public static final String IMG_CODE_BACK = "back.gif";
    public static final String IMG_CODE_BOOKMARK = "bookmark.gif";
    public static final String IMG_CODE_COLUMN = "column.gif";
    public static final String IMG_CODE_CLOCK = "clock.gif";
    public static final String IMG_CODE_DB_ADD = "db_add.gif";
    public static final String IMG_CODE_DB_EDIT = "db_edit.gif";
    public static final String IMG_CODE_DB_COPY = "db_copy.gif";
    public static final String IMG_CODE_DB_DELETE = "db_delete.gif";
    public static final String IMG_CODE_DB = "db.gif";
    public static final String IMG_CODE_CONNECTED_DB = "connecteddb.gif";
    public static final String IMG_CODE_FORWARD = "forward.gif";
    public static final String IMG_CODE_DB_NEW = "new_db.gif";
    public static final String IMG_CODE_NOTNULL_COLUMN = "notNull.gif";
    public static final String IMG_CODE_PK_COLUMN = "primarykey.gif";
    public static final String IMG_CODE_REFRESH = "refresh.gif";
    public static final String IMG_CODE_SCHEMA = "schema.gif";
    public static final String IMG_CODE_SQL = "sql.gif";
    public static final String IMG_CODE_TABLE = "table.gif";
    public static final String IMG_CODE_DISABLED_TABLE = "disabledtable.gif";
    public static final String IMG_CODE_DISABLED_SYNONYM = "disabledsynonym.gif";
    public static final String IMG_CODE_UNIQUEKEY = "uniquekey.gif";
    public static final String IMG_CODE_ASC = "asc.gif";
    public static final String IMG_CODE_DESC = "desc.gif";
    public static final String IMG_CODE_BLANK = "blank.gif";
    public static final String IMG_CODE_SAVE = "save.gif";
    public static final String IMG_CODE_UNKNOWN = "unknown.gif";
    public static final String IMG_CODE_CHECKED = "checked.gif";
    public static final String IMG_CODE_UNCHECKED = "unchecked.gif";
    public static final String IMG_CODE_DISABLED_CHECKED = "disabledchecked.gif";
    public static final String IMG_CODE_CHECKED_CENTER = "checkedcenter.gif";
    public static final String IMG_CODE_UNCHECKED_CENTER = "uncheckedcenter.gif";
    public static final String IMG_CODE_DISABLED_CHECKED_CENTER = "disabledcheckedcenter.gif";
    public static final String IMG_CODE_TEMPLATE = "template.gif";
    public static final String IMG_CODE_VIEW = "view.gif";
    public static final String IMG_CODE_FUNCTION = "function.gif";
    public static final String IMG_CODE_SYNONYM = "synonym.gif";
    public static final String IMG_CODE_SEQUENCE = "sequence.gif";
    public static final String IMG_CODE_EXECUTE = "execute.gif";
    public static final String IMG_CODE_CLEAR = "clear.gif";
    public static final String IMG_CODE_COMMIT = "commit.gif";
    public static final String IMG_CODE_ROLLBACK = "rollback.gif";
    public static final String IMG_CODE_IMPORT = "import.gif";
    public static final String IMG_CODE_EXPORT = "export.gif";
    public static final String IMG_CODE_FORMAT = "format.gif";
    public static final String IMG_CODE_FORMAT2 = "format2.gif";
    public static final String IMG_CODE_VERTICALLAYOUT = "verticallayout.gif";
    public static final String IMG_CODE_HORIZONTALLAYOUT = "horizontallayout.gif";
    public static final String IMG_CODE_REMOVE = "remove_exc.gif";
    public static final String IMG_CODE_REMOVE_ALL = "removea_exc.gif";
    public static final String IMG_CODE_PIN = "pin.gif";
    public static final String IMG_CODE_OPEN = "open.gif";
    public static final String IMG_CODE_SYNCED = "synced.gif";
    public static final String IMG_CODE_COLUMN_ADD = "column_add.gif";
    public static final String IMG_CODE_COLUMN_EDIT = "column_edit.gif";
    public static final String IMG_CODE_COLUMN_DEL = "column_del.gif";
    public static final String IMG_CODE_COLUMN_DUPLICATE = "column_duplicate.gif";
    public static final String IMG_CODE_SCRIPT = "script.gif";
    public static final String IMG_CODE_ERROR_ROOT = "error_root.gif";
    public static final String IMG_CODE_ERROR = "error.gif";
    public static final String IMG_CODE_AUTO = "auto_commit.gif";
    public static final String IMG_CODE_MANUAL = "manual_commit.gif";
    public static final String IMG_CODE_DUMMY = "dummy.gif";
    public static final String IMG_CODE_FILTER = "filter.gif";
    public static final String IMG_CODE_PIN_COLUMN = "pin_column.gif";
    public static final String IMG_CODE_ALIAS = "alias.gif";
    public static final String IMG_CODE_RESULT = "result.gif";
    public static final String IMG_CODE_ADD = "add.gif";
    public static final String IMG_CODE_TOP = "top.gif";
    public static final String IMG_CODE_END = "end.gif";
    public static final String IMG_CODE_PREVIOUS = "previous.gif";
    public static final String IMG_CODE_NEXT = "next.gif";
    public static final String IMG_CODE_EXPAND_ALL = "expandAll.gif";
    public static final String IMG_CODE_COLLAPSE_ALL = "collapseAll.gif";
    public static final String IMG_CODE_WARNING = "warning.gif";
    static String secondarlyId;

    static {
        listeners = new ArrayList();
        secondarlyId = null;
    }

    public DbPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("ResourceBundleMessages");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.xmlController = new XmlController(this.getStateLocation());
        this.imageCacher = ImageCacher.getInstance();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            this.imageCacher.clear();
            this.saveDBDialogSettings();
            this.xmlController.save();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    public static DbPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = DbPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public SQLHistoryManager getHistoryManager() {
        return this.xmlController.getHistoryManager();
    }

    public ConditionManager getConditionManager() {
        return this.xmlController.getConditionManager();
    }

    public BookmarkManager getBookmarkManager() {
        return this.xmlController.getBookmarkManager();
    }

    public PluginSettingsManager getPluginSettingsManager() {
        return this.xmlController.getPluginSettingsManager();
    }

    public synchronized IDBDialogSettings getDBDialogSettings() {
        if (this.dBDialogSettings == null) {
            this.loadDBDialogSettings();
        }
        return this.dBDialogSettings;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadDBDialogSettings() {
        this.dBDialogSettings = new DBDialogSettings("Workbench");
        String readWritePath = this.getStateLocation().append("db_settings.xml").toOSString();
        File settingsFile = new File(readWritePath);
        if (settingsFile.exists()) {
            try {
                this.dBDialogSettings.load(readWritePath);
                return;
            }
            catch (IOException iOException) {
                this.dBDialogSettings = new DBDialogSettings("Workbench");
                return;
            }
        }
        URL dsURL = BundleUtility.find((Bundle)this.getBundle(), (String)"db_settings.xml");
        if (dsURL == null) {
            return;
        }
        InputStream is = null;
        try {
            try {
                is = dsURL.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                this.dBDialogSettings.load(reader);
            }
            catch (IOException iOException) {
                this.dBDialogSettings = new DBDialogSettings("Workbench");
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (is == null) return;
        is.close();
    }

    public void saveDBDialogSettings() {
        if (this.dBDialogSettings == null) {
            return;
        }
        try {
            String readWritePath = this.getStateLocation().append("db_settings.xml").toOSString();
            this.dBDialogSettings.save(readWritePath);
        }
        catch (IOException e) {
            DbPlugin.log(e);
        }
    }

    public static IViewPart findView(String viewId) {
        IWorkbenchPage page = DbPlugin.getDefault().getPage();
        if (page != null) {
            return page.findView(viewId);
        }
        return null;
    }

    public static IViewPart findView(String viewId, String secondaryId) throws PartInitException {
        IWorkbenchPage page = DbPlugin.getDefault().getPage();
        if (page != null) {
            return page.showView(viewId, secondaryId, 2);
        }
        return null;
    }

    public static IViewPart showView(String viewId) throws PartInitException {
        IWorkbenchPage page = DbPlugin.getDefault().getPage();
        if (page != null) {
            return page.showView(viewId);
        }
        return null;
    }

    public static IViewPart showView(String viewId, String secondaryId) throws PartInitException {
        IWorkbenchPage page = DbPlugin.getDefault().getPage();
        if (page != null) {
            return page.showView(viewId, secondaryId, 1);
        }
        return null;
    }

    public static void hideView(IViewPart view) {
        IWorkbenchPage page = DbPlugin.getDefault().getPage();
        if (page != null && view != null) {
            DbPlugin.getDefault().getPage().hideView(view);
        }
    }

    public IWorkbenchPage getPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getActivePage();
    }

    public Shell getShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getShell();
    }

    public static ITableViewEditor getActiveTableViewEditor() {
        IEditorPart editor = DbPlugin.getDefault().getPage().getActiveEditor();
        if (editor instanceof ITableViewEditor) {
            return (ITableViewEditor)editor;
        }
        return null;
    }

    public static void getCloseEditors(IEditorReference[] editorRefs) {
        DbPlugin.getDefault().getPage().closeEditors(editorRefs, true);
    }

    public void showInformationMessage(String message) {
        MessageDialog.openInformation((Shell)this.getShell(), (String)"ZIGEN's DBViewer Plugin", (String)message);
    }

    public void showWarningMessage(String message) {
        MessageDialog.openWarning((Shell)this.getShell(), (String)"ZIGEN's DBViewer Plugin", (String)message);
    }

    public boolean confirmDialog(String message) {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)"ZIGEN's DBViewer Plugin", (String)message);
    }

    public MessageDialogWithToggle confirmDialogWithToggle(String message, String toggleMessage, boolean toggleStatus) {
        return MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)"ZIGEN's DBViewer Plugin", (String)message, (String)toggleMessage, (boolean)toggleStatus, null, null);
    }

    public String getDefaultProject() {
        return this.defaultProject;
    }

    public void setDefaultProject(String defaultProject) {
        this.defaultProject = defaultProject;
    }

    private static String getPluginId() {
        return DbPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(String message, Throwable e) {
        Status status = new Status(4, DbPlugin.getPluginId(), 4, message, e);
        DbPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        DbPlugin.log(message, null);
    }

    public static void log(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String message = stringWriter.getBuffer().toString();
        DbPlugin.log(message, e);
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void log(IStatus status) {
        DbPlugin.getDefault().getLog().log(status);
    }

    private static String getErrorMessage(Throwable throwable) {
        if (throwable != null) {
            String msg = throwable.getMessage();
            if (msg == null) {
                return DbPlugin.getErrorMessage(throwable.getCause());
            }
            return msg;
        }
        return Messages.getString("DbPlugin.ConfrimStatckTraceMessage");
    }

    private static String getFirstLineMessage(String message) {
        StringUtil.convertLineSep(message);
        int pos = message.indexOf("\n");
        if (pos > 0) {
            return message.substring(0, pos);
        }
        return message;
    }

    static IStatus createErrorStatus(Throwable throwable) {
        String msg = DbPlugin.getErrorMessage(throwable);
        String lineMsg = DbPlugin.getFirstLineMessage(msg);
        return new Status(4, DbPlugin.getPluginId(), 0, lineMsg, throwable);
    }

    public static IStatus createWarningStatus(Throwable throwable) {
        return DbPlugin.createWarningStatus(-1, throwable);
    }

    static IStatus createWarningStatus(int errorCode, Throwable throwable) {
        String msg = DbPlugin.getErrorMessage(throwable);
        msg = DbPlugin.getFirstLineMessage(msg);
        return new Status(2, DbPlugin.getPluginId(), errorCode, msg, null);
    }

    public void showErrorDialog(Throwable throwable) {
        JobException je;
        Throwable cause;
        if (throwable != null) {
            throwable.printStackTrace();
        }
        String message = Messages.getString("DbPlugin.ErrorMessage");
        IStatus status = null;
        status = throwable instanceof JobException ? ((cause = (je = (JobException)throwable).getCause()) instanceof SQLException ? DbPlugin.createErrorStatus(cause) : DbPlugin.createErrorStatus(cause)) : (throwable instanceof SQLException ? DbPlugin.createErrorStatus(throwable) : DbPlugin.createErrorStatus(throwable));
        ErrorDialog.openError((Shell)this.getShell(), (String)"ZIGEN's DBViewer Plugin", (String)message, (IStatus)status);
    }

    public String getDefaultSaveDir() {
        return this.defaultSaveDir;
    }

    public void setDefaultSaveDir(String defaultSaveDir) {
        this.defaultSaveDir = defaultSaveDir;
    }

    public ImageDescriptor getImageDescriptor(String imageKey) {
        return this.getImageRegistry().getDescriptor(imageKey);
    }

    public Image getImage(String imageCode) {
        return this.imageCacher.getImage(imageCode);
    }

    public static Font getDefaultFont() {
        Font font = JFaceResources.getTextFont();
        return font;
    }

    public static Font getSmallFont() {
        Font newFont = null;
        Font font = DbPlugin.getDefaultFont();
        FontData[] datas = font.getFontData();
        if (datas.length > 0) {
            FontData data = datas[0];
            int currnetHeight = data.getHeight();
            data.setHeight(currnetHeight - 1);
            newFont = new Font((Device)Display.getDefault(), data);
        }
        return newFont;
    }

    public static FontData getDefaultFontData() {
        Font font = DbPlugin.getDefaultFont();
        FontData[] datas = font.getFontData();
        if (datas.length > 0) {
            return datas[0];
        }
        return null;
    }

    public static SqlFormatRule getSqlFormatRult() {
        SqlFormatRule rule = DbPluginFormatRule.getInstance().getRule();
        IPreferenceStore st = DbPlugin.getDefault().getPreferenceStore();
        int tabSize = st.getInt("SQLEditorPreferencePage.FormatTabSize");
        boolean optDecode = st.getBoolean("SQLEditorPreferencePage.FormatOptionDecode");
        boolean optIn = st.getBoolean("SQLEditorPreferencePage.FormatOptionIn");
        rule.setIndentString(StringUtil.padding("", tabSize));
        rule.setDecodeSpecialFormat(!optDecode);
        rule.setInSpecialFormat(optIn);
        return rule;
    }

    public static IDBConfig[] getDBConfigs() {
        TreeView tv = (TreeView)DbPlugin.findView("zigen.plugin.db.ui.views.TreeView");
        if (tv != null) {
            TreeContentProvider tcp = tv.getContentProvider();
            return tcp.getDBConfigs();
        }
        return null;
    }

    public static void addStatusChangeListener(IStatusChangeListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeStatusChangeListener(IStatusChangeListener listener) {
        listeners.remove(listener);
    }

    public static void fireStatusChangeListener(Object obj, int status) {
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            IStatusChangeListener element = (IStatusChangeListener)iter.next();
            if (element == null) continue;
            element.statusChanged(obj, status);
        }
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, IMG_CODE_SQL);
        this.registerImage(registry, IMG_CODE_SCHEMA);
        this.registerImage(registry, IMG_CODE_TABLE);
        this.registerImage(registry, IMG_CODE_DISABLED_TABLE);
        this.registerImage(registry, IMG_CODE_DISABLED_SYNONYM);
        this.registerImage(registry, IMG_CODE_PK_COLUMN);
        this.registerImage(registry, IMG_CODE_COLUMN);
        this.registerImage(registry, IMG_CODE_PK_COLUMN);
        this.registerImage(registry, IMG_CODE_NOTNULL_COLUMN);
        this.registerImage(registry, IMG_CODE_EXECUTE);
        this.registerImage(registry, IMG_CODE_CLEAR);
        this.registerImage(registry, IMG_CODE_FORWARD);
        this.registerImage(registry, IMG_CODE_BACK);
        this.registerImage(registry, IMG_CODE_REFRESH);
        this.registerImage(registry, IMG_CODE_COMMIT);
        this.registerImage(registry, IMG_CODE_ROLLBACK);
        this.registerImage(registry, IMG_CODE_DB_ADD);
        this.registerImage(registry, IMG_CODE_DB_EDIT);
        this.registerImage(registry, IMG_CODE_DB_DELETE);
        this.registerImage(registry, IMG_CODE_BOOKMARK);
        this.registerImage(registry, IMG_CODE_CLOCK);
        this.registerImage(registry, IMG_CODE_DB);
        this.registerImage(registry, IMG_CODE_CONNECTED_DB);
        this.registerImage(registry, IMG_CODE_DB_NEW);
        this.registerImage(registry, IMG_CODE_DB_COPY);
        this.registerImage(registry, IMG_CODE_ASC);
        this.registerImage(registry, IMG_CODE_DESC);
        this.registerImage(registry, IMG_CODE_BLANK);
        this.registerImage(registry, IMG_CODE_SAVE);
        this.registerImage(registry, IMG_CODE_UNKNOWN);
        this.registerImage(registry, IMG_CODE_CHECKED);
        this.registerImage(registry, IMG_CODE_UNCHECKED);
        this.registerImage(registry, IMG_CODE_DISABLED_CHECKED);
        this.registerImage(registry, IMG_CODE_CHECKED_CENTER);
        this.registerImage(registry, IMG_CODE_UNCHECKED_CENTER);
        this.registerImage(registry, IMG_CODE_DISABLED_CHECKED_CENTER);
        this.registerImage(registry, IMG_CODE_TEMPLATE);
        this.registerImage(registry, IMG_CODE_VIEW);
        this.registerImage(registry, IMG_CODE_FUNCTION);
        this.registerImage(registry, IMG_CODE_SYNONYM);
        this.registerImage(registry, IMG_CODE_SEQUENCE);
        this.registerImage(registry, IMG_CODE_IMPORT);
        this.registerImage(registry, IMG_CODE_EXPORT);
        this.registerImage(registry, IMG_CODE_FORMAT);
        this.registerImage(registry, IMG_CODE_FORMAT2);
        this.registerImage(registry, IMG_CODE_VERTICALLAYOUT);
        this.registerImage(registry, IMG_CODE_HORIZONTALLAYOUT);
        this.registerImage(registry, IMG_CODE_REMOVE);
        this.registerImage(registry, IMG_CODE_REMOVE_ALL);
        this.registerImage(registry, IMG_CODE_PIN);
        this.registerImage(registry, IMG_CODE_OPEN);
        this.registerImage(registry, IMG_CODE_SYNCED);
        this.registerImage(registry, IMG_CODE_COLUMN_ADD);
        this.registerImage(registry, IMG_CODE_COLUMN_EDIT);
        this.registerImage(registry, IMG_CODE_COLUMN_DEL);
        this.registerImage(registry, IMG_CODE_COLUMN_DUPLICATE);
        this.registerImage(registry, IMG_CODE_SCRIPT);
        this.registerImage(registry, IMG_CODE_ERROR_ROOT);
        this.registerImage(registry, IMG_CODE_ERROR);
        this.registerImage(registry, IMG_CODE_AUTO);
        this.registerImage(registry, IMG_CODE_MANUAL);
        this.registerImage(registry, IMG_CODE_DUMMY);
        this.registerImage(registry, IMG_CODE_FILTER);
        this.registerImage(registry, IMG_CODE_PIN_COLUMN);
        this.registerImage(registry, IMG_CODE_ALIAS);
        this.registerImage(registry, IMG_CODE_RESULT);
        this.registerImage(registry, IMG_CODE_ADD);
        this.registerImage(registry, IMG_CODE_TOP);
        this.registerImage(registry, IMG_CODE_END);
        this.registerImage(registry, IMG_CODE_PREVIOUS);
        this.registerImage(registry, IMG_CODE_NEXT);
        this.registerImage(registry, IMG_CODE_EXPAND_ALL);
        this.registerImage(registry, IMG_CODE_COLLAPSE_ALL);
        this.registerImage(registry, IMG_CODE_WARNING);
    }

    private void registerImage(ImageRegistry registry, String fileName) {
        try {
            Path path = new Path("icons/" + fileName);
            URL url = this.find((IPath)path);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(fileName, desc);
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    public static void setSecondarlyId(String _secondarlyId) {
        secondarlyId = _secondarlyId;
    }

    public static String getSecondarlyId() {
        return secondarlyId;
    }
}

