/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Messages;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableHeaderElement;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.AbstractMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;
import zigen.plugin.db.ui.actions.MaxRecordException;

public class SQLInvoker {
    public static TableElement[] executeQuery(IDBConfig config, String query) throws Exception, MaxRecordException {
        Connection con = Transaction.getInstance(config).getConnection();
        return SQLInvoker.executeQuery(con, query, config.isConvertUnicode(), config.isNoLockMode());
    }

    public static TableElement[] executeQuery(Connection con, String query, boolean convUnicode, boolean isNoLockMode) throws Exception, MaxRecordException {
        TableElement[] tableElementArray;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            if (isNoLockMode && 3 == DBType.getType(con.getMetaData()) && !query.trim().endsWith("WITH OPTION LOCK_MODE(NL)")) {
                query = String.valueOf(query) + " WITH OPTION LOCK_MODE(NL)";
            }
            rs = stmt.executeQuery(query);
            ResultSetMetaData meta = rs.getMetaData();
            ArrayList<TableElement> list = new ArrayList<TableElement>();
            TableColumn[] columns = SQLInvoker.getTableColumns(meta);
            TableHeaderElement header = new TableHeaderElement(columns);
            list.add(header);
            int size = meta.getColumnCount();
            int recordNo = 1;
            int limit = DbPlugin.getDefault().getPreferenceStore().getInt("PreferencePage.MaxViewRecord");
            IMappingFactory factory = AbstractMappingFactory.getFactory(con.getMetaData(), convUnicode);
            while (rs.next()) {
                if (limit > 0 && recordNo > limit) {
                    String msg = Messages.getString("SQLInvoker.2");
                    throw new MaxRecordException(msg, list.toArray(new TableElement[0]));
                }
                Object[] items = new Object[size];
                int i = 0;
                while (i < size) {
                    items[i] = factory.getObject(rs, i + 1);
                    ++i;
                }
                TableElement elements = new TableElement(recordNo, columns, items);
                ++recordNo;
                list.add(elements);
            }
            tableElementArray = list.toArray(new TableElement[0]);
            Object var16_19 = null;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                ResultSetUtil.close(rs);
                StatementUtil.close(stmt);
                throw throwable;
            }
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(stmt);
        return tableElementArray;
    }

    private static TableColumn[] getTableColumns(ResultSetMetaData meta) throws SQLException {
        int count = meta.getColumnCount();
        TableColumn[] columns = new TableColumn[count];
        int i = 0;
        while (i < count) {
            TableColumn column = new TableColumn();
            column.setColumnName(meta.getColumnName(i + 1));
            column.setTypeName(meta.getColumnTypeName(i + 1));
            column.setDataType(meta.getColumnType(i + 1));
            column.setColumnSize(meta.getColumnDisplaySize(i + 1));
            column.setDecimalDigits(meta.getScale(i + 1));
            columns[i] = column;
            ++i;
        }
        return columns;
    }

    public static int executeUpdate(IDBConfig config, String sql) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return SQLInvoker.executeUpdate(con, sql);
    }

    public static int executeUpdate(Connection con, String sql) throws Exception {
        int n;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            n = stmt.executeUpdate(sql);
            Object var4_4 = null;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                StatementUtil.close(stmt);
                throw throwable;
            }
        }
        StatementUtil.close(stmt);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(Connection con, String sql) throws Exception {
        boolean b = false;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(sql);
            b = true;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            StatementUtil.close(stmt);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        StatementUtil.close(stmt);
        return b;
    }

    public static long executeQueryTotalCount(Connection con, String query, int timeoutSec) throws Exception {
        long l;
        ResultSet rs = null;
        Statement stmt = null;
        long totalCount = 0L;
        try {
            stmt = con.createStatement();
            if (timeoutSec > 0) {
                try {
                    stmt.setQueryTimeout(timeoutSec);
                }
                catch (SQLException e) {
                    e.getStackTrace();
                }
            }
            if ((rs = stmt.executeQuery(query)).next()) {
                totalCount = rs.getLong(1);
            }
            l = totalCount;
            Object var8_9 = null;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                ResultSetUtil.close(rs);
                StatementUtil.close(stmt);
                throw throwable;
            }
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(stmt);
        return l;
    }
}

