/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import zigen.plugin.db.DbPlugin;

class SqlStreamTokenizer
extends StreamTokenizer {
    public static final char TT_SPACE = ' ';
    public static final char TT_QUOTE = '\'';
    public static final char TT_DOUBLE_QUOTE = '\"';
    public static final char TT_COMMA = ',';
    public static final int TT_WORD = -3;
    private int tokenType = -1;
    private String token;

    public SqlStreamTokenizer(String sql) {
        super(new StringReader(sql));
        this.resetSyntax();
        this.wordChars(48, 57);
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(95, 95);
        this.wordChars(46, 46);
        this.whitespaceChars(9, 9);
        this.whitespaceChars(10, 10);
        this.whitespaceChars(13, 13);
        this.quoteChar(39);
        this.quoteChar(34);
        this.eolIsSignificant(false);
        this.slashStarComments(true);
        this.slashSlashComments(true);
    }

    public int nextToken() {
        try {
            this.tokenType = super.nextToken();
            switch (this.tokenType) {
                case -1: {
                    this.tokenType = -1;
                    this.token = null;
                    break;
                }
                case -3: {
                    this.token = this.sval;
                    this.tokenType = -3;
                    break;
                }
                case 39: {
                    this.token = "'" + this.sval + "'";
                    break;
                }
                case 34: {
                    this.token = "\"" + this.sval + "\"";
                    break;
                }
                default: {
                    this.token = String.valueOf((char)this.ttype);
                    System.out.println(this.token);
                    break;
                }
            }
        }
        catch (IOException e) {
            DbPlugin.log(e);
        }
        return this.tokenType;
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public String getToken() {
        return this.token;
    }
}

