/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import zigen.plugin.db.diff.Messages;

public class ProjectSelectDialog
extends TitleAreaDialog {
    TreeViewer viewer;
    Text fileText;
    String saveFileName;
    IContainer container;
    private String title = Messages.getString("ProjectSelectDialog.1");
    static /* synthetic */ Class class$0;

    public ProjectSelectDialog(Shell parentShell, String text) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        parentShell.setText(text);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        super.setTitle(this.title);
        super.setMessage(Messages.getString("ProjectSelectDialog.5"), 0);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.viewer = new TreeViewer(composite2, 2048);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite3, 0);
        label.setText(Messages.getString("ProjectSelectDialog.2"));
        this.fileText = new Text(composite3, 2048);
        this.fileText.setLayoutData((Object)new GridData(768));
        this.fileText.setText(Messages.getString("ProjectSelectDialog.3"));
        this.fileText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (ProjectSelectDialog.this.fileText.getText().trim().length() == 0) {
                    ProjectSelectDialog.this.getButton(0).setEnabled(false);
                } else {
                    ProjectSelectDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.viewer.addFilter((ViewerFilter)new SourceDirViewerFilter());
        WorkbenchLabelProvider provider = new WorkbenchLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        this.viewer.setInput((Object)ws);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSelectDialog.this.selectionChangeHandler(event);
            }
        });
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control ctl = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        return ctl;
    }

    protected void okPressed() {
        this.saveFileName = this.fileText.getText().trim();
        super.okPressed();
    }

    private void selectionChangeHandler(SelectionChangedEvent event) {
        Object obj = ((StructuredSelection)event.getSelection()).getFirstElement();
        if (obj instanceof IAdaptable) {
            IResource resource;
            IAdaptable adaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)adaptable.getAdapter((Class)clazz)) instanceof IProject || resource instanceof IFolder) {
                this.container = (IContainer)resource;
                this.getButton(0).setEnabled(true);
            } else if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                this.fileText.setText(file.getName());
                this.container = file.getParent();
                this.getButton(0).setEnabled(true);
            }
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    private void validate() {
        IFile file;
        IContainer container = this.getContainer();
        if (container != null && (file = container.getFile((IPath)new Path(this.getSaveFileName()))).exists()) {
            super.setMessage(Messages.getString("ProjectSelectDialog.4"), 2);
        }
    }

    protected Point getInitialSize() {
        return new Point(480, 450);
    }

    public IContainer getContainer() {
        return this.container;
    }

    public String getSaveFileName() {
        return this.saveFileName;
    }

    public void setSaveFileName(String saveFileName) {
        this.saveFileName = saveFileName;
    }

    class SourceDirViewerFilter
    extends ViewerFilter {
        static /* synthetic */ Class class$0;

        SourceDirViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IAdaptable) {
                IResource res;
                IAdaptable adaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((res = (IResource)adaptable.getAdapter((Class)clazz)) != null) {
                    if (res instanceof IProject || res instanceof IFolder) {
                        return true;
                    }
                    return "diff".equals(res.getFileExtension().toLowerCase());
                }
                return false;
            }
            return false;
        }
    }
}

