/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;

public class OracleSourceErrorSearcher {
    public static OracleSourceErrorInfo[] execute(IDBConfig config, String owner, String name, String type) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleSourceErrorSearcher.execute(con, owner, name, type);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OracleSourceErrorInfo[] execute(Connection con, String owner, String name, String type) throws Exception {
        ArrayList<OracleSourceErrorInfo> list = null;
        ResultSet rs = null;
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                rs = st.executeQuery(OracleSourceErrorSearcher.getSQL(owner, name, type));
                list = new ArrayList<OracleSourceErrorInfo>();
                while (rs.next()) {
                    OracleSourceErrorInfo info = new OracleSourceErrorInfo();
                    info.setOwner(rs.getString("OWNER"));
                    info.setName(rs.getString("NAME"));
                    info.setType(rs.getString("TYPE"));
                    info.setLine(rs.getInt("LINE"));
                    info.setPosition(rs.getInt("POSITION"));
                    info.setText(rs.getString("TEXT"));
                    list.add(info);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return list.toArray(new OracleSourceErrorInfo[0]);
    }

    private static String getSQL(String owner, String name, String type) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT");
        sb.append("         OWNER");
        sb.append("         ,NAME");
        sb.append("         ,TYPE");
        sb.append("         ,LINE");
        sb.append("         ,POSITION");
        sb.append("         ,TEXT");
        sb.append("     FROM");
        sb.append("         ALL_ERRORS");
        sb.append("     WHERE");
        sb.append("         OWNER = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("         AND NAME = '" + SQLUtil.encodeQuotation(name) + "'");
        sb.append("         AND TYPE = '" + SQLUtil.encodeQuotation(type) + "'");
        sb.append("     ORDER BY SEQUENCE");
        return sb.toString();
    }
}

