/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.tablespace.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ext.oracle.internal.OracleDbBlockSizeSearcher;
import zigen.plugin.db.ext.oracle.tablespace.wizard.CalcTableSpaceWizard;
import zigen.plugin.db.ext.oracle.tablespace.wizard.DefaultWizardPage;
import zigen.plugin.db.ext.oracle.tablespace.wizard.IItem;
import zigen.plugin.db.ext.oracle.tablespace.wizard.Messages;
import zigen.plugin.db.ext.oracle.tablespace.wizard.TableItem;
import zigen.plugin.db.ext.oracle.tablespace.wizard.WizardPage1;
import zigen.plugin.db.ext.oracle.tablespace.wizard.WizardPage2CellEditorValidator;
import zigen.plugin.db.ext.oracle.tablespace.wizard.WizardPage2CellModifier;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;

public class WizardPage2
extends DefaultWizardPage {
    private DbBlockSizeVerifyListener verifyListener = new DbBlockSizeVerifyListener();
    public static final String HEADER_TABLENAME = Messages.getString("WizardPage2.0");
    public static final String HEADER_BLOCKSIZE = Messages.getString("WizardPage2.1");
    public static final String HEADER_PCTFREE = Messages.getString("WizardPage2.2");
    public static final String HEADER_RECORD = Messages.getString("WizardPage2.3");
    public static final int COLUMN_TABLENAME = 0;
    public static final int COLUMN_PCTFREE = 1;
    public static final int COLUMN_RECORD = 2;
    Text dbBlockSizeText;

    public WizardPage2() {
        super("wizardPage");
        this.setTitle(Messages.getString("WizardPage2.5"));
        this.setDescription(Messages.getString("WizardPage2.6"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = this.createDefaultComposite(container);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.getString("WizardPage2.7"));
        this.dbBlockSizeText = new Text(composite, 2052);
        this.dbBlockSizeText.addFocusListener((FocusListener)new TextSelectionListener());
        this.dbBlockSizeText.addVerifyListener((VerifyListener)this.verifyListener);
        this.dbBlockSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardPage2.this.dialogChanged();
            }
        });
        this.createTable(container);
        this.setControl((Control)container);
    }

    private void createTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.HEIGHT_HINT;
        gridData.widthHint = this.WIDTH_HINT;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(composite, 68352);
        gridData = new GridData(1808);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] headers = new String[]{HEADER_TABLENAME, HEADER_PCTFREE, HEADER_RECORD};
        this.setHeaderColumn(table, headers);
        this.tableViewer.setColumnProperties(headers);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = new TextCellEditor((Composite)table);
        cellEditorArray[2] = new TextCellEditor((Composite)table);
        CellEditor[] editors = cellEditorArray;
        int i = 0;
        while (i < editors.length) {
            if (editors[i] != null) {
                editors[i].setValidator((ICellEditorValidator)new WizardPage2CellEditorValidator(i));
            }
            ++i;
        }
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new WizardPage2CellModifier(this));
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        if (this.tableItems != null) {
            this.tableViewer.setInput((Object)this.tableItems);
            this.columnsPack(table);
        }
    }

    private void dialogChanged() {
        if (this.dbBlockSizeText.getText().length() == 0) {
            this.updateStatus(Messages.getString("WizardPage2.8"));
            return;
        }
        this.updateStatus(null);
    }

    private void setHeaderColumn(Table table, String[] headers) {
        int i = 0;
        while (i < headers.length) {
            TableColumn col = headers[i].equals(HEADER_TABLENAME) ? new TableColumn(table, 0, i) : new TableColumn(table, 131072, i);
            col.setText(headers[i]);
            col.setResizable(false);
            col.pack();
            ++i;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            CalcTableSpaceWizard wiz = (CalcTableSpaceWizard)this.getWizard();
            WizardPage1 page = (WizardPage1)wiz.getPreviousPage((IWizardPage)this);
            this.tableItems = page.tableItems;
            if (this.tableItems != null) {
                if (this.dbBlockSizeText.getText() == null || "".equals(this.dbBlockSizeText.getText())) {
                    try {
                        int dbBlockSize = OracleDbBlockSizeSearcher.execute(page.schemaNode.getDbConfig());
                        this.dbBlockSizeText.removeVerifyListener((VerifyListener)this.verifyListener);
                        this.dbBlockSizeText.setText(String.valueOf(dbBlockSize));
                        this.dbBlockSizeText.addVerifyListener((VerifyListener)this.verifyListener);
                    }
                    catch (Exception e) {
                        DbPlugin.getDefault().showErrorDialog(e);
                    }
                }
                this.tableViewer.setInput((Object)this.tableItems);
                this.columnsPack(this.tableViewer.getTable());
            }
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private List contents = null;

        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IItem[]) {
                List checkedList = this.getCheckedList((TableItem[])inputElement);
                return checkedList.toArray(new TableItem[0]);
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contents = null;
        }

        public void dispose() {
            this.contents = null;
        }

        private List getCheckedList(TableItem[] items) {
            ArrayList<TableItem> checkedList = new ArrayList<TableItem>();
            int i = 0;
            while (i < items.length) {
                if (items[i].isChecked()) {
                    checkedList.add(items[i]);
                }
                ++i;
            }
            return checkedList;
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            TableItem item = (TableItem)element;
            switch (columnIndex) {
                case 0: {
                    result = item.table.getName();
                    break;
                }
                case 1: {
                    result = String.valueOf(item.getPctFree());
                    break;
                }
                case 2: {
                    result = String.valueOf(item.getRecordSize());
                    break;
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    private class DbBlockSizeVerifyListener
    implements VerifyListener {
        private String acceptableChar = "1234567890";

        private DbBlockSizeVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            char cfr_ignored_0 = e.character;
            if (e.character == '\b' || e.character == '\u007f') {
                return;
            }
            if (this.acceptableChar.indexOf(Character.toString(e.character)) == -1) {
                e.doit = false;
            }
        }
    }
}

