/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.jobs.ConnectDBJob;
import zigen.plugin.db.ui.jobs.OracleSequeceSearchJob;
import zigen.plugin.db.ui.jobs.OracleSourceSearchJob;
import zigen.plugin.db.ui.jobs.RefreshFolderJob;
import zigen.plugin.db.ui.jobs.RefreshTableJob;
import zigen.plugin.db.ui.jobs.TableTypeSearchJob;

public class RefreshAction
extends Action {
    private boolean showDialog = true;
    private TreeViewer viewer = null;

    public RefreshAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("RefreshAction.0"));
        this.setToolTipText(Messages.getString("RefreshAction.1"));
        this.setAccelerator(0x100000E);
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("refresh.gif"));
        this.setDisabledImageDescriptor(DbPlugin.getDefault().getImageDescriptor("refresh.gif"));
    }

    public void run() {
        Object element = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
        try {
            if (element instanceof DataBase) {
                DataBase db = (DataBase)element;
                db.removeChildAll();
                db.setExpanded(false);
                db.setConnected(true);
                ConnectDBJob job = new ConnectDBJob(this.viewer, db);
                job.setPriority(20);
                job.setUser(false);
                job.setSystem(false);
                job.schedule();
            } else if (element instanceof Schema) {
                Schema schema = (Schema)element;
                schema.setExpanded(true);
                TableTypeSearchJob job = new TableTypeSearchJob(this.viewer, schema);
                job.setUser(this.showDialog);
                job.setPriority(20);
                job.schedule();
            } else if (element instanceof Folder) {
                Folder folder = (Folder)element;
                folder.setExpanded(true);
                Schema schema = folder.getSchema();
                if (schema != null) {
                    switch (DBType.getType(schema.getDbConfig())) {
                        case 1: {
                            if (schema == null) break;
                            if ("SEQUENCE".equals(folder.getName())) {
                                OracleSequeceSearchJob job = new OracleSequeceSearchJob(this.viewer, folder);
                                job.setPriority(20);
                                job.setUser(this.showDialog);
                                job.schedule();
                                return;
                            }
                            String[] sTypes = schema.getSourceType();
                            if (sTypes == null) break;
                            int i = 0;
                            while (i < sTypes.length) {
                                String stype = sTypes[i];
                                if (stype.equals(folder.getName())) {
                                    OracleSourceSearchJob job = new OracleSourceSearchJob(this.viewer, folder);
                                    job.setPriority(20);
                                    job.setUser(this.showDialog);
                                    job.schedule();
                                    return;
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                }
                RefreshFolderJob job = new RefreshFolderJob(this.viewer, folder);
                job.setPriority(20);
                job.setUser(this.showDialog);
                job.schedule();
            } else if (element instanceof ITable) {
                ITable table = (ITable)element;
                table.setExpanded(true);
                RefreshTableJob job = new RefreshTableJob(this.viewer, table);
                job.setPriority(20);
                job.setUser(this.showDialog);
                job.schedule();
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

