/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.contentassist;

import java.util.List;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.contentassist.ProcessorInfo;
import zigen.plugin.db.ui.internal.Column;

public class SQLProposalCreator2 {
    public static void addProposal(List proposals, String[] modifiers, ProcessorInfo pinfo) {
        String word = pinfo.getWord();
        int offset = pinfo.getOffset();
        boolean isAfterPeriod = pinfo.isAfterPeriod();
        if (modifiers != null) {
            Image img = SQLProposalCreator2.getImage("sql.gif");
            if (isAfterPeriod) {
                word = "";
            }
            int len = word.length();
            int i = 0;
            while (i < modifiers.length) {
                String modifier = modifiers[i];
                String value = ContentAssistUtil.subString(modifiers[i], len);
                if (value != null && value.compareToIgnoreCase(word) == 0) {
                    proposals.add(new CompletionProposal(modifier, offset - len, len, modifier.length(), img, null, (IContextInformation)new ContextInformation(null, modifier), null));
                }
                ++i;
            }
        }
    }

    public static void addProposal(List proposals, String[][] modifiers, ProcessorInfo pinfo) {
        String word = pinfo.getWord();
        int offset = pinfo.getOffset();
        boolean isAfterPeriod = pinfo.isAfterPeriod();
        if (modifiers != null) {
            Image img = SQLProposalCreator2.getImage("unknown.gif");
            if (isAfterPeriod) {
                word = "";
            }
            int len = word.length();
            int i = 0;
            while (i < modifiers.length) {
                String modifier = modifiers[i][0];
                String display = modifiers[i][1];
                String value = ContentAssistUtil.subString(modifier, len);
                if (value != null && value.compareToIgnoreCase(word) == 0) {
                    proposals.add(new CompletionProposal(modifier, offset - len, len, modifier.length(), img, display, (IContextInformation)new ContextInformation(null, modifier), null));
                }
                ++i;
            }
        }
    }

    public static void addProposal(List proposals, TableInfo[] tables, ProcessorInfo pinfo) {
        String word = pinfo.getWord();
        int offset = pinfo.getOffset();
        boolean isAfterPeriod = pinfo.isAfterPeriod();
        if (tables != null) {
            Image img = null;
            if (isAfterPeriod) {
                word = "";
            }
            int len = word.length();
            int i = 0;
            while (i < tables.length) {
                String value;
                String modifier;
                TableInfo info = tables[i];
                img = "TABLE".equals(info.getTableType()) ? SQLProposalCreator2.getImage("table.gif") : ("VIEW".equals(info.getTableType()) ? SQLProposalCreator2.getImage("view.gif") : ("SYNONYM".equals(info.getTableType()) ? SQLProposalCreator2.getImage("synonym.gif") : ("FUNCTION".equals(info.getTableType()) ? SQLProposalCreator2.getImage("function.gif") : ("SEQUENCE".equals(info.getTableType()) ? SQLProposalCreator2.getImage("sequence.gif") : SQLProposalCreator2.getImage("unknown.gif")))));
                String display = modifier = info.getName();
                String comment = info.getComment();
                if (comment != null && !"".equals(comment)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(modifier);
                    sb.append(" [");
                    sb.append(comment);
                    sb.append("]");
                    display = sb.toString();
                }
                if ((value = ContentAssistUtil.subString(modifier, len)) != null && value.compareToIgnoreCase(word) == 0) {
                    proposals.add(new CompletionProposal(modifier, offset - len, len, modifier.length(), img, display, (IContextInformation)new ContextInformation(null, modifier), null));
                }
                ++i;
            }
        }
    }

    public static void addProposal(List proposals, Column[] columns, ProcessorInfo pinfo) {
        String word = pinfo.getWord();
        int offset = pinfo.getOffset();
        boolean isAfterPeriod = pinfo.isAfterPeriod();
        if (columns != null) {
            if (isAfterPeriod) {
                word = "";
            }
            int len = word.length();
            int i = 0;
            while (i < columns.length) {
                Image img = SQLProposalCreator2.getImage("column.gif");
                Column info = columns[i];
                if (info.hasPrimaryKey()) {
                    img = SQLProposalCreator2.getImage("primarykey.gif");
                } else if (info.isNotNull()) {
                    img = SQLProposalCreator2.getImage("notNull.gif");
                }
                String modifier = info.getName();
                String display = info.getColumnLabel();
                String value = ContentAssistUtil.subString(modifier, len);
                if (value != null && value.compareToIgnoreCase(word) == 0) {
                    proposals.add(new CompletionProposal(modifier, offset - len, len, modifier.length(), img, display, (IContextInformation)new ContextInformation(null, modifier), null));
                }
                ++i;
            }
        }
    }

    public static void addProposalForFunction(List proposals, String[] modifiers, ProcessorInfo pinfo) {
        String word = pinfo.getWord();
        int offset = pinfo.getOffset();
        boolean isAfterPeriod = pinfo.isAfterPeriod();
        if (modifiers != null) {
            Image img = SQLProposalCreator2.getImage("function.gif");
            if (isAfterPeriod) {
                word = "";
            }
            int len = word.length();
            int i = 0;
            while (i < modifiers.length) {
                String modifier = modifiers[i];
                String value = ContentAssistUtil.subString(modifiers[i], len);
                if (value != null && value.compareToIgnoreCase(word) == 0) {
                    proposals.add(new CompletionProposal(modifier, offset - len, len, modifier.length(), img, null, (IContextInformation)new ContextInformation(null, modifier), null));
                }
                ++i;
            }
        }
    }

    private static Image getImage(String imageCode) {
        return ImageCacher.getInstance().getImage(imageCode);
    }
}

