/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.sql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;

public class SourceEditorInput
implements IStorageEditorInput,
IEditorInput {
    private String tooltip;
    private String name;
    private IDBConfig config;
    private OracleSourceDetailInfo sourceDetailInfo;
    private OracleSourceErrorInfo[] sourceErrorInfos;

    public SourceEditorInput(IDBConfig config, OracleSourceDetailInfo sourceDetailInfo, OracleSourceErrorInfo[] sourceErrorInfos) {
        this.config = config;
        this.sourceDetailInfo = sourceDetailInfo;
        this.sourceErrorInfos = sourceErrorInfos;
        this.name = String.valueOf(sourceDetailInfo.getName()) + "[" + sourceDetailInfo.getType() + "]";
        this.tooltip = String.valueOf(sourceDetailInfo.getName()) + "[" + sourceDetailInfo.getType() + "]";
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SourceEditorInput) {
            SourceEditorInput input = (SourceEditorInput)o;
            if (this.config.getDbName().equals(input.config.getDbName())) {
                return this.name.equals(input.getName());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public IDBConfig getConfig() {
        return this.config;
    }

    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
    }

    public OracleSourceErrorInfo[] getSourceErrorInfos() {
        return this.sourceErrorInfos;
    }

    public OracleSourceDetailInfo getSourceDetailInfo() {
        return this.sourceDetailInfo;
    }

    public IStorage getStorage() throws CoreException {
        return this.createStore();
    }

    private IStorage createStore() {
        return new IStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return false;
            }

            public String getName() {
                return null;
            }

            public IPath getFullPath() {
                return null;
            }

            public InputStream getContents() throws CoreException {
                if (SourceEditorInput.this.sourceDetailInfo != null) {
                    return new ByteArrayInputStream(SourceEditorInput.this.sourceDetailInfo.getText().getBytes());
                }
                return new ByteArrayInputStream(new byte[0]);
            }
        };
    }
}

