/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.internal;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.ContentAssistTable;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.TreeLeaf;

public class Column
extends TreeLeaf {
    protected TableColumn column;
    protected TablePKColumn pkColumn = null;
    protected TableFKColumn[] fkColumns = null;

    public boolean isNotNull() {
        return this.column.isNotNull();
    }

    public Column(TableColumn column) {
        super(column.getColumnName());
        this.column = column;
    }

    public Column(TableColumn column, TablePKColumn pkColumn, TableFKColumn[] fkColumns) {
        this(column);
        this.pkColumn = pkColumn;
        this.fkColumns = fkColumns;
    }

    public void update(Column node) {
        this.column = node.column;
        this.pkColumn = node.pkColumn;
        this.fkColumns = node.fkColumns;
    }

    public void update(TableColumn column, TablePKColumn pkColumn, TableFKColumn[] fkColumns) {
        this.name = column.getColumnName();
        this.column = column;
        this.pkColumn = pkColumn;
        this.fkColumns = fkColumns;
    }

    public TableColumn getColumn() {
        return this.column;
    }

    public String getName() {
        return this.column.getColumnName();
    }

    public String getColumnLabel() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.column.getColumnName());
        sb.append(" ");
        sb.append(this.column.getTypeName().toLowerCase());
        if (this.isVisibleColumnSize()) {
            if (this.column.getDecimalDigits() == 0) {
                sb.append("(" + this.column.getColumnSize() + ")");
            } else {
                sb.append("(" + this.column.getColumnSize() + "," + this.column.getDecimalDigits() + ")");
            }
        }
        if (this.pkColumn != null) {
            sb.append(" PK");
        }
        if (this.fkColumns != null && this.fkColumns.length > 0) {
            sb.append(" FK");
        }
        if (DbPlugin.getDefault().getPreferenceStore().getBoolean("DBTreeViewPreferencePage.DisplayColumnComment") && this.column.getRemarks() != null && this.column.getRemarks().length() > 0) {
            sb.append(" [");
            sb.append(this.column.getRemarks());
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean isVisibleColumnSize() {
        IDBConfig config = null;
        ITable table = null;
        if (this.getParent() instanceof Bookmark) {
            Bookmark bk = (Bookmark)this.getParent();
            config = bk.getDbConfig();
            table = bk;
        } else if (this.getParent() instanceof ContentAssistTable) {
            ContentAssistTable cat = (ContentAssistTable)this.getParent();
            config = cat.getDbConfig();
            table = cat.getTable();
        } else {
            config = this.getDbConfig();
            table = this.getTable();
        }
        if (config != null && table != null) {
            ISQLCreatorFactory factory = AbstractSQLCreatorFactory.getFactory(config, table);
            return factory.isVisibleColumnSize(this.column.getTypeName());
        }
        return true;
    }

    public String getLogicalColumnLabel() {
        StringBuffer sb = new StringBuffer();
        if (this.column.getRemarks() != null && this.column.getRemarks().length() > 0) {
            sb.append(this.column.getRemarks());
        } else {
            sb.append(this.column.getColumnName());
        }
        sb.append("\uff1a");
        sb.append(this.column.getTypeName().toLowerCase());
        if (this.column.getDecimalDigits() == 0) {
            sb.append("(" + this.column.getColumnSize() + ")");
        } else {
            sb.append("(" + this.column.getColumnSize() + "," + this.column.getDecimalDigits() + ")");
        }
        if (this.pkColumn != null) {
            sb.append(" <Primary Key>");
        }
        return sb.toString();
    }

    public TableFKColumn[] getFkColumns() {
        return this.fkColumns;
    }

    public TablePKColumn getPkColumn() {
        return this.pkColumn;
    }

    public boolean hasPrimaryKey() {
        return this.pkColumn != null;
    }

    public boolean hasForeignKey() {
        return this.fkColumns != null && this.fkColumns.length > 0;
    }

    public Column() {
    }

    public void setColumn(TableColumn column) {
        this.column = column;
    }

    public void setFkColumns(TableFKColumn[] fkColumns) {
        this.fkColumns = fkColumns;
    }

    public void setPkColumn(TablePKColumn pkColumn) {
        this.pkColumn = pkColumn;
    }

    public String getSize() {
        StringBuffer sb = new StringBuffer();
        if (this.isVisibleColumnSize() && !this.column.isWithoutParam()) {
            if (this.column.getDecimalDigits() == 0) {
                sb.append(this.column.getColumnSize());
            } else {
                sb.append(this.column.getColumnSize());
                sb.append(",");
                sb.append(this.column.getDecimalDigits());
            }
        }
        return sb.toString();
    }

    public int getDataType() {
        return this.column.getDataType();
    }

    public int getDecimalDigits() {
        return this.column.getDecimalDigits();
    }

    public String getDefaultValue() {
        return this.column.getDefaultValue();
    }

    public String getRemarks() {
        return this.column.getRemarks();
    }

    public int getSeq() {
        return this.column.getSeq();
    }

    public String getTypeName() {
        return this.column.getTypeName().toUpperCase();
    }

    public void setName(String columnName) {
        this.column.setColumnName(columnName);
    }

    public void setSize(String size) {
        try {
            if (size != null && !"".equals(size) && this.isVisibleColumnSize()) {
                int comma = size.indexOf(44);
                if (comma > 0) {
                    int _size = Integer.parseInt(size.substring(0, comma));
                    int _degits = Integer.parseInt(size.substring(comma + 1));
                    this.column.setColumnSize(_size);
                    this.column.setDecimalDigits(_degits);
                } else {
                    this.column.setColumnSize(Integer.parseInt(size));
                    this.column.setDecimalDigits(0);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setTypeName(String typeName) {
        this.column.setTypeName(typeName);
    }

    public void setDefaultValue(String defaultValue) {
        this.column.setDefaultValue(defaultValue);
    }

    public void setRemark(String remarks) {
        this.column.setRemarks(remarks);
    }

    public void setNotNull(boolean notNull) {
        this.column.setNotNull(notNull);
    }
}

