/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.internal;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.ui.internal.Column;

public class OracleColumn
extends Column {
    public OracleColumn() {
    }

    public OracleColumn(TableColumn column) {
        super(column);
    }

    public OracleColumn(TableColumn column, TablePKColumn pkColumn, TableFKColumn[] fkColumns) {
        super(column, pkColumn, fkColumns);
    }

    public void update(OracleColumn node) {
        super.update(node);
    }

    public String getColumnLabel() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.column.getColumnName());
        sb.append(" ");
        sb.append(this.column.getTypeName().toLowerCase());
        if (this.isVisibleColumnSize() && !this.column.isWithoutParam()) {
            if (this.column.getDecimalDigits() == 0) {
                sb.append("(" + this.column.getColumnSize() + ")");
            } else {
                sb.append("(" + this.column.getColumnSize() + "," + this.column.getDecimalDigits() + ")");
            }
        }
        if (this.pkColumn != null) {
            sb.append(" PK");
        }
        if (this.fkColumns != null && this.fkColumns.length > 0) {
            sb.append(" FK");
        }
        if (DbPlugin.getDefault().getPreferenceStore().getBoolean("DBTreeViewPreferencePage.DisplayColumnComment") && this.column.getRemarks() != null && this.column.getRemarks().length() > 0) {
            sb.append(" [");
            sb.append(this.column.getRemarks());
            sb.append("]");
        }
        return sb.toString();
    }
}

