/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceSearcher;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.OracleFunction;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;

public class OracleSourceSearchJob
extends AbstractJob {
    private TreeViewer viewer;
    private Folder folder;

    public OracleSourceSearchJob(TreeViewer viewer, Folder folder) {
        super(Messages.getString("OracleSourceSearchJob.0"));
        this.viewer = viewer;
        this.folder = folder;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Search Oracle Source...", 10);
            Connection con = Transaction.getInstance(this.folder.getDbConfig()).getConnection();
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.folder.removeChildAll();
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.folder));
            Schema schema = (Schema)this.folder.getParent();
            String owner = schema.getName();
            String type = this.folder.getName();
            OracleSourceInfo[] infos = OracleSourceSearcher.execute(con, owner, type);
            this.addSources(con, this.folder, infos);
            this.folder.setExpanded(true);
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.folder, 0));
            monitor.done();
        }
        catch (Exception e) {
            this.folder.setExpanded(false);
            this.showErrorMessage(Messages.getString("OracleSourceSearchJob.1"), e);
        }
        return Status.OK_STATUS;
    }

    private void addSources(Connection con, Folder folder, OracleSourceInfo[] infos) throws Exception {
        int i = 0;
        while (i < infos.length) {
            OracleSource source = "FUNCTION".equals(folder.getName()) ? new OracleFunction() : new OracleSource();
            source.setOracleSourceInfo(infos[i]);
            folder.addChild(source);
            ++i;
        }
    }
}

