/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLTokenizer;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.views.SQLExecuteView;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class SqlFormatJob
extends AbstractJob {
    protected SQLSourceViewer viewer;
    protected IDocument doc;
    protected String secondarlyId;
    protected int executeCount;
    private String targetSql;
    private String formattedSql;
    int selectOffset;
    int selectLength;
    String selectedSql;
    TextSelection selection;
    boolean selectionMode = false;
    int formattOffset = 0;
    int firstWordPosition = 0;

    public SqlFormatJob(SQLSourceViewer viewer, String secondarlyId) {
        super("SQL Formatting...");
        this.viewer = viewer;
        this.doc = viewer.getDocument();
        this.secondarlyId = secondarlyId;
        this.selection = (TextSelection)viewer.getSelection();
        if (this.selection != null && this.selection.getText().length() > 0) {
            this.targetSql = this.selection.getText();
            this.selectionMode = true;
            this.calcurate(this.doc, this.selection);
        } else {
            this.targetSql = viewer.getDocument().get();
            this.selectionMode = false;
        }
        this.formattedSql = this.targetSql;
    }

    private void calcurate(IDocument doc, TextSelection selection) {
        try {
            int sOffset = doc.getLineOffset(selection.getStartLine());
            this.firstWordPosition = StringUtil.firstWordPosition(selection.getText());
            this.formattOffset = selection.getOffset() - sOffset + this.firstWordPosition;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        String responseTime = null;
        try {
            IStatus iStatus;
            try {
                TimeWatcher tw = new TimeWatcher();
                tw.start();
                IPreferenceStore ps = DbPlugin.getDefault().getPreferenceStore();
                String demiliter = ps.getString("SQLEditorPreferencePage.SqlDemiliter");
                boolean onPatch = ps.getBoolean("SQLEditorPreferencePage.FormatPatch");
                int type = ps.getInt("SQLFormatPreferencePage.UseFormatterType");
                int max = ps.getInt("SQLEditorPreferencePage.MaxSqlCount");
                StringBuffer sb = new StringBuffer();
                SQLTokenizer st = new SQLTokenizer(this.targetSql, demiliter);
                int tokenCount = st.getTokenCount();
                int i = 0;
                while (true) {
                    if (i >= tokenCount) break;
                    String sql = (String)st.nextElement();
                    if (sql != null && sql.length() > 0) {
                        if (i < max) {
                            sb.append(SQLFormatter.format(sql, type, onPatch, this.formattOffset));
                        } else {
                            sb.append(sql);
                        }
                        if (!this.selectionMode) {
                            this.addLine(sb, demiliter);
                        } else if (tokenCount > 1) {
                            this.addLine(sb, demiliter);
                        }
                        if (monitor.isCanceled()) {
                            IStatus iStatus2 = Status.CANCEL_STATUS;
                            Object var14_17 = null;
                            this.showResults(new UnLockAction(this.secondarlyId, responseTime));
                            return iStatus2;
                        }
                    }
                    ++i;
                }
                this.formattedSql = sb.toString();
                tw.stop();
                responseTime = tw.getTotalTime();
                this.showResults(new ShowResultAction(this.secondarlyId, sb.toString()));
                iStatus = Status.OK_STATUS;
                Object var14_18 = null;
            }
            catch (Exception e) {
                this.showErrorMessage("\u30a8\u30e9\u30fc", e);
            }
            this.showResults(new UnLockAction(this.secondarlyId, responseTime));
            return iStatus;
            Object var14_20 = null;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.showResults(new UnLockAction(this.secondarlyId, responseTime));
            throw throwable;
        }
        this.showResults(new UnLockAction(this.secondarlyId, responseTime));
        return Status.OK_STATUS;
    }

    private void addLine(StringBuffer sb, String demiliter) {
        if ("/".equals(demiliter)) {
            sb.append(DbPluginConstant.LINE_SEP);
        }
        sb.append(demiliter);
        sb.append(DbPluginConstant.LINE_SEP);
    }

    public String getFormattedSql() {
        return this.formattedSql;
    }

    protected class ShowResultAction
    implements Runnable {
        String secondaryId = null;
        String formattedSql = null;

        public ShowResultAction(String secondaryId, String formattedSql) {
            this.secondaryId = secondaryId;
            this.formattedSql = formattedSql;
        }

        public void run() {
            try {
                IDocument doc = SqlFormatJob.this.viewer.getDocument();
                int offset = SqlFormatJob.this.viewer.getTextWidget().getCaretOffset();
                int line = doc.getLineOfOffset(offset);
                int x = offset - doc.getLineOffset(line);
                doc.getLineOfOffset(offset);
                SqlFormatJob.this.viewer.getTextWidget().getCaretOffset();
                String preSql = null;
                TextSelection selection = (TextSelection)SqlFormatJob.this.viewer.getSelection();
                if (selection != null && selection.getLength() > 0) {
                    preSql = selection.getText();
                    doc.replace(selection.getOffset() + SqlFormatJob.this.firstWordPosition, preSql.length() - SqlFormatJob.this.firstWordPosition, this.formattedSql);
                } else {
                    preSql = doc.get();
                    doc.replace(0, preSql.length(), this.formattedSql);
                }
                SqlFormatJob.this.viewer.setEditable(true);
                if (SqlFormatJob.this.selectionMode) {
                    this.setSelection((ISourceViewer)SqlFormatJob.this.viewer, (ISelection)new TextSelection(selection.getOffset() + SqlFormatJob.this.firstWordPosition, this.formattedSql.length()), true);
                } else {
                    int maxLine = doc.getLineOfOffset(this.formattedSql.length());
                    if (line > maxLine) {
                        line = maxLine;
                    }
                    int lineLength = doc.getLineLength(line);
                    String cr = doc.getLineDelimiter(line);
                    if (cr != null) {
                        lineLength -= cr.length();
                    }
                    if (lineLength < x) {
                        x = lineLength;
                    }
                    int newOffset = doc.getLineOffset(line) + x;
                    if (this.formattedSql.length() < newOffset) {
                        newOffset = this.formattedSql.length();
                    }
                    this.setSelection((ISourceViewer)SqlFormatJob.this.viewer, (ISelection)new TextSelection(newOffset, 0), true);
                }
                SqlFormatJob.this.viewer.getTextWidget().notifyListeners(13, null);
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }

        void setSelection(ISourceViewer viewer, ISelection selection, boolean reveal) {
            if (selection instanceof ITextSelection) {
                ITextSelection s = (ITextSelection)selection;
                viewer.setSelectedRange(s.getOffset(), s.getLength());
                if (reveal) {
                    viewer.revealRange(s.getOffset(), s.getLength());
                }
            }
        }
    }

    protected class UnLockAction
    implements Runnable {
        String secondaryId = null;
        String responseTime = null;

        public UnLockAction(String secondaryId, String responseTime) {
            this.secondaryId = secondaryId;
            this.responseTime = responseTime;
        }

        public void run() {
            try {
                DbPlugin.getDefault().getPage();
                DbPlugin.getDefault();
                SQLExecuteView view = (SQLExecuteView)DbPlugin.findView("zigen.plugin.db.ui.views.SQLExecuteView", this.secondaryId);
                if (view != null) {
                    if (!view.getSqlViewer().isEditable()) {
                        view.getSqlViewer().setEditable(true);
                    }
                    if (this.responseTime != null && !"".equals(this.responseTime)) {
                        view.setStatusMessage("formatted. " + this.responseTime);
                    }
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }
}

