/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.jobs.ConnectDBJob;
import zigen.plugin.db.ui.jobs.OpenEditorJob;
import zigen.plugin.db.ui.jobs.OpenSourceEditorJob;
import zigen.plugin.db.ui.jobs.OracleSequeceSearchJob;
import zigen.plugin.db.ui.jobs.OracleSourceSearchJob;
import zigen.plugin.db.ui.jobs.RefreshFolderJob;
import zigen.plugin.db.ui.jobs.TableTypeSearchJob;

public class TreeDoubleClickHandler
implements IDoubleClickListener {
    private boolean showDialog = false;

    public void doubleClick(DoubleClickEvent event) {
        try {
            Viewer view = event.getViewer();
            ISelection selection = event.getSelection();
            if (view instanceof TreeViewer && selection instanceof StructuredSelection) {
                TreeViewer viewer = (TreeViewer)view;
                Object element = ((StructuredSelection)selection).getFirstElement();
                if (element instanceof DataBase) {
                    DataBase db = (DataBase)element;
                    if (!db.isExpanded()) {
                        db.setConnected(true);
                        db.setExpanded(true);
                        ConnectDBJob job = new ConnectDBJob(viewer, db);
                        job.setPriority(20);
                        job.setUser(false);
                        job.setSystem(false);
                        job.schedule();
                    } else {
                        this.changeExpandedState(viewer, (TreeNode)element);
                    }
                } else if (element instanceof ITable) {
                    OpenEditorJob job = new OpenEditorJob(viewer, (ITable)element);
                    job.setPriority(20);
                    job.setUser(this.showDialog);
                    job.schedule();
                } else if (element instanceof OracleSource || element instanceof OracleSequence) {
                    OpenSourceEditorJob job = new OpenSourceEditorJob((StructuredViewer)viewer);
                    job.setPriority(20);
                    job.setUser(this.showDialog);
                    job.schedule();
                } else if (element instanceof TreeNode) {
                    this.changeExpandedState(viewer, (TreeNode)element);
                }
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    private void changeExpandedState(TreeViewer viewer, TreeNode element) {
        if (!viewer.getExpandedState((Object)element)) {
            Folder folder;
            viewer.expandToLevel((Object)element, 1);
            if (element instanceof Schema) {
                Schema schema = (Schema)element;
                if (!schema.isExpanded()) {
                    schema.setExpanded(true);
                    TableTypeSearchJob job = new TableTypeSearchJob(viewer, schema);
                    job.setPriority(20);
                    job.setUser(this.showDialog);
                    job.schedule();
                }
            } else if (element instanceof Folder && !(folder = (Folder)element).isExpanded()) {
                folder.setExpanded(true);
                Schema schema = folder.getSchema();
                if (schema != null) {
                    switch (DBType.getType(schema.getDbConfig())) {
                        case 1: {
                            if (schema == null) break;
                            if ("SEQUENCE".equals(folder.getName())) {
                                OracleSequeceSearchJob job = new OracleSequeceSearchJob(viewer, folder);
                                job.setPriority(20);
                                job.setUser(this.showDialog);
                                job.schedule();
                                return;
                            }
                            if ("VIEW".equals(folder.getName())) {
                                RefreshFolderJob job = new RefreshFolderJob(viewer, folder);
                                job.setPriority(20);
                                job.setUser(this.showDialog);
                                job.schedule();
                                return;
                            }
                            String[] sTypes = schema.getSourceType();
                            if (sTypes == null) break;
                            int i = 0;
                            while (i < sTypes.length) {
                                String stype = sTypes[i];
                                if (stype.equals(folder.getName())) {
                                    OracleSourceSearchJob job = new OracleSourceSearchJob(viewer, folder);
                                    job.setPriority(20);
                                    job.setUser(this.showDialog);
                                    job.schedule();
                                    return;
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                    RefreshFolderJob job = new RefreshFolderJob(viewer, folder);
                    job.setPriority(20);
                    job.setUser(this.showDialog);
                    job.schedule();
                }
            }
        } else {
            viewer.collapseToLevel((Object)element, 1);
        }
    }
}

