/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.diff.DDLDiff;
import zigen.plugin.db.diff.IDDLDiff;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.BookmarkRoot;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.History;
import zigen.plugin.db.ui.internal.HistoryFolder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleFunction;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Synonym;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.internal.View;

public class TreeLabelProvider
extends LabelProvider {
    ImageCacher ic = ImageCacher.getInstance();

    public String getText(Object obj) {
        if (obj instanceof Column) {
            Column column = (Column)obj;
            TableColumn _column = column.getColumn();
            if (_column.getTypeName() != null) {
                return ((Column)obj).getColumnLabel();
            }
            return obj.toString();
        }
        if (obj instanceof ITable) {
            ITable table = (ITable)obj;
            if (DbPlugin.getDefault().getPreferenceStore().getBoolean("DBTreeViewPreferencePage.DisplayTableComment")) {
                return table.getLabel();
            }
            return table.getName();
        }
        if (obj instanceof Schema) {
            Schema schema = (Schema)obj;
            return schema.getName();
        }
        if (obj instanceof History) {
            History history = (History)obj;
            return history.getName();
        }
        if (obj instanceof DDLDiff) {
            IDDLDiff diff = (IDDLDiff)obj;
            return diff.getName();
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        String imageKey = "IMG_OBJ_ELEMENTS";
        if (obj instanceof Root) {
            return this.ic.getImage("db.gif");
        }
        if (obj instanceof DataBase) {
            DataBase db = (DataBase)obj;
            if (db.isConnected()) {
                return this.ic.getImage("connecteddb.gif");
            }
            return this.ic.getImage("db.gif");
        }
        if (obj instanceof Schema) {
            return this.ic.getImage("schema.gif");
        }
        if (obj instanceof BookmarkRoot) {
            return this.ic.getImage("bookmark.gif");
        }
        if (obj instanceof Synonym) {
            Synonym synonym = (Synonym)obj;
            if (synonym.isEnabled()) {
                return this.ic.getImage("synonym.gif");
            }
            return this.ic.getImage("disabledsynonym.gif");
        }
        if (obj instanceof View) {
            return this.ic.getImage("view.gif");
        }
        if (obj instanceof Bookmark) {
            Bookmark bm = (Bookmark)obj;
            if (bm.getType() == 0) {
                return this.ic.getImage("table.gif");
            }
            if (1 == bm.getType()) {
                return this.ic.getImage("view.gif");
            }
            if (2 == bm.getType()) {
                return this.ic.getImage("synonym.gif");
            }
            imageKey = "IMG_OBJ_FILE";
        } else {
            if (obj instanceof ITable) {
                ITable table = (ITable)obj;
                if (table.isEnabled()) {
                    return this.ic.getImage("table.gif");
                }
                return this.ic.getImage("disabledtable.gif");
            }
            if (obj instanceof Column) {
                Column col = (Column)obj;
                if (col.hasPrimaryKey()) {
                    return this.ic.getImage("primarykey.gif");
                }
                if (col.isNotNull()) {
                    return this.ic.getImage("notNull.gif");
                }
                return this.ic.getImage("column.gif");
            }
            if (obj instanceof History) {
                return this.ic.getImage("clock.gif");
            }
            if (obj instanceof HistoryFolder) {
                imageKey = "IMG_OBJ_FOLDER";
            } else {
                if (obj instanceof DDLDiff) {
                    return this.ic.getImage("table.gif");
                }
                if (obj instanceof OracleFunction) {
                    return this.ic.getImage("function.gif");
                }
                if (obj instanceof OracleSource) {
                    imageKey = "IMG_OBJ_FILE";
                } else {
                    if (obj instanceof OracleSequence) {
                        return this.ic.getImage("sequence.gif");
                    }
                    if (obj instanceof TreeNode) {
                        imageKey = "IMG_OBJ_FOLDER";
                    }
                }
            }
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
    }
}

