/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.jobs.ConnectDBJob;
import zigen.plugin.db.ui.jobs.OracleSequeceSearchJob;
import zigen.plugin.db.ui.jobs.OracleSourceSearchJob;
import zigen.plugin.db.ui.jobs.RefreshColumnJob;
import zigen.plugin.db.ui.jobs.RefreshFolderJob;
import zigen.plugin.db.ui.jobs.TableTypeSearchJob;

public class TreeViewListener
implements ITreeViewerListener {
    private boolean showDialog = true;

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Folder folder;
        Object element = event.getElement();
        TreeViewer viewer = (TreeViewer)event.getTreeViewer();
        if (element instanceof DataBase) {
            DataBase db = (DataBase)element;
            if (!db.isExpanded()) {
                db.setExpanded(true);
                ConnectDBJob job = new ConnectDBJob(viewer, db);
                job.setPriority(20);
                job.setUser(false);
                job.setSystem(false);
                job.schedule();
            }
        } else if (element instanceof Schema) {
            Schema schema = (Schema)element;
            if (!schema.isExpanded()) {
                schema.setExpanded(true);
                TableTypeSearchJob job = new TableTypeSearchJob(viewer, schema);
                job.setPriority(20);
                job.setUser(this.showDialog);
                job.schedule();
            }
        } else if (element instanceof ITable) {
            ITable table = (ITable)element;
            if (!table.isExpanded()) {
                RefreshColumnJob job = new RefreshColumnJob(viewer, table);
                job.setPriority(20);
                job.setUser(false);
                job.schedule();
            }
        } else if (element instanceof Folder && !(folder = (Folder)element).isExpanded()) {
            folder.setExpanded(true);
            Schema schema = folder.getSchema();
            if (schema != null) {
                RefreshFolderJob job;
                switch (DBType.getType(schema.getDbConfig())) {
                    case 1: {
                        if (schema == null) break;
                        if ("SEQUENCE".equals(folder.getName())) {
                            OracleSequeceSearchJob job2 = new OracleSequeceSearchJob(viewer, folder);
                            job2.setPriority(20);
                            job2.setUser(this.showDialog);
                            job2.schedule();
                            return;
                        }
                        if ("VIEW".equals(folder.getName())) {
                            job = new RefreshFolderJob(viewer, folder);
                            job.setPriority(20);
                            job.setUser(this.showDialog);
                            job.schedule();
                            break;
                        }
                        String[] sTypes = schema.getSourceType();
                        if (sTypes == null) break;
                        int i = 0;
                        while (i < sTypes.length) {
                            String stype = sTypes[i];
                            if (stype.equals(folder.getName())) {
                                OracleSourceSearchJob job3 = new OracleSourceSearchJob(viewer, folder);
                                job3.setPriority(20);
                                job3.setUser(this.showDialog);
                                job3.schedule();
                                return;
                            }
                            ++i;
                        }
                        break;
                    }
                }
                job = new RefreshFolderJob(viewer, folder);
                job.setPriority(20);
                job.setUser(this.showDialog);
                job.schedule();
            }
        }
    }
}

