/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.jdt;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import zigen.plugin.db.ext.jdt.Messages;

public class Activator
extends AbstractUIPlugin {
    public static String LINE_SEP = System.getProperty("line.separator");
    public static final String TITLE = "ZIGEN's DBViewer Plugin";
    public static final String VERSION = "1.0.0 release 2007/10/10";
    public static final String PLUGIN_ID = "zigen.plugin.db.ext.jdt";
    private static Activator plugin;
    private String defaultProject = null;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    private static String getPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public String getDefaultProject() {
        return this.defaultProject;
    }

    public void setDefaultProject(String defaultProject) {
        this.defaultProject = defaultProject;
    }

    public IWorkbenchPage getPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getActivePage();
    }

    public Shell getShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getShell();
    }

    public static IStatus createWarningStatus(Throwable throwable) {
        return Activator.createWarningStatus(-1, throwable);
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static IStatus createErrorStatus(Throwable throwable) {
        return Activator.createErrorStatus(-1, throwable);
    }

    private static String getErrorMessage(Throwable throwable) {
        if (throwable != null) {
            String msg = throwable.getMessage();
            if (msg == null) {
                return Activator.getErrorMessage(throwable.getCause());
            }
            return msg;
        }
        return Messages.getString("Activator.0");
    }

    static IStatus createWarningStatus(int errorCode, Throwable throwable) {
        String msg = Activator.getErrorMessage(throwable);
        int endIndex = msg.indexOf(LINE_SEP);
        if (endIndex > 0) {
            msg = msg.substring(0, endIndex);
        }
        return new Status(2, Activator.getPluginId(), errorCode, msg, null);
    }

    static IStatus createErrorStatus(int errorCode, Throwable throwable) {
        String msg = Activator.getErrorMessage(throwable);
        int endIndex = msg.indexOf(LINE_SEP);
        if (endIndex > 0) {
            msg = msg.substring(0, endIndex);
        }
        return new Status(4, Activator.getPluginId(), errorCode, msg, throwable);
    }

    public void showErrorDialog(Throwable throwable) {
        String message = Messages.getString("Activator.1");
        IStatus status = null;
        status = throwable instanceof SQLException ? Activator.createWarningStatus(throwable) : Activator.createErrorStatus(throwable);
        ErrorDialog.openError((Shell)this.getShell(), (String)TITLE, (String)message, (IStatus)status);
    }

    public static void log(String message, Exception e) {
        Status status = new Status(4, Activator.getPluginId(), 4, message, (Throwable)e);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String message = stringWriter.getBuffer().toString();
        Activator.log(message, e);
        if (e != null) {
            e.printStackTrace();
        }
    }
}

