/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.jdt.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ext.jdt.Activator;
import zigen.plugin.db.ext.jdt.ui.Messages;

public class DBPropertyPage
extends PropertyPage {
    private static final String CONNECT_DB = Messages.getString("DBPropertyPage.0");
    public static final String QUALIFIER = "zigen.plugin.db";
    public static final String SELECTED_DB = "SELECTED_DB";
    public static final String INITIAL_VALUE = Messages.getString("DBPropertyPage.3");
    private Combo selectCombo;
    private IDBConfig[] configs;
    private IProject project;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.createSelectCombo(composite);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void createSelectCombo(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(CONNECT_DB);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.selectCombo = new Combo(composite, 8);
        this.selectCombo.setLayoutData((Object)data);
        this.selectCombo.add(INITIAL_VALUE);
        this.configs = DBConfigManager.getDBConfigs();
        IAdaptable obj = this.getElement();
        if (obj instanceof IJavaProject) {
            this.project = ((IJavaProject)obj).getProject();
            this.setDefaultValue(this.project);
        } else if (obj instanceof IProject) {
            this.project = (IProject)obj;
            this.setDefaultValue(this.project);
        }
    }

    private void setDefaultValue(IProject project) {
        try {
            String dbName = project.getPersistentProperty(new QualifiedName(QUALIFIER, SELECTED_DB));
            int i = 0;
            while (i < this.configs.length) {
                IDBConfig w_config = this.configs[i];
                this.selectCombo.add(w_config.getDbName());
                if (i == 0) {
                    this.selectCombo.select(0);
                }
                if (dbName != null && dbName.equals(w_config.getDbName())) {
                    this.selectCombo.select(i + 1);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    protected void performDefaults() {
    }

    public boolean performOk() {
        try {
            int i;
            if (this.project != null && (i = this.selectCombo.getSelectionIndex()) >= 0) {
                String dbName = this.selectCombo.getItem(i);
                this.project.setPersistentProperty(new QualifiedName(QUALIFIER, SELECTED_DB), dbName);
            }
        }
        catch (Exception e) {
            Activator.log(e);
            return false;
        }
        return true;
    }
}

