/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.jdt.ui;

import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import zigen.plugin.db.ext.jdt.Activator;
import zigen.plugin.db.ext.jdt.ICodeGenerator;
import zigen.plugin.db.ext.jdt.ui.Messages;
import zigen.plugin.db.ext.jdt.ui.PackageSelectDialog;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.views.ColumnSearchAction;
import zigen.plugin.db.ui.views.TreeView;

public abstract class GenerateAction
implements IObjectActionDelegate {
    protected String project;
    protected IAction action;
    protected IStructuredSelection selection;
    protected TreeView treeView;
    protected StructuredViewer structuredViewer;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (!(targetPart instanceof TreeView)) {
            throw new RuntimeException("Required TreeView");
        }
        this.project = Activator.getDefault().getDefaultProject();
        this.treeView = (TreeView)targetPart;
        this.structuredViewer = this.treeView.getTreeViewer();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
        if (!(selection instanceof IStructuredSelection)) {
            this.action.setEnabled(false);
            throw new RuntimeException("Required IStructuredSelection.");
        }
        this.selection = (IStructuredSelection)selection;
        this.action.setEnabled(true);
    }

    protected void createFileAndOpen(PackageFragment pkg, String fileName, String contents) throws JavaModelException, PartInitException {
        pkg.createCompilationUnit(fileName, contents, true, (IProgressMonitor)new NullProgressMonitor());
        String pkgName = pkg.getElementName().replace('.', '/');
        String srcPath = pkg.getPackageFragmentRoot().getPath().toString();
        IContainer container = pkg.getJavaProject().getProject().getParent();
        Path path = new Path(String.valueOf(srcPath) + "/" + pkgName + "/" + fileName);
        IFile file = container.getFile((IPath)path);
        IWorkbenchPage page = Activator.getDefault().getPage();
        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
    }

    protected boolean existFile(PackageFragment pkg, String checkFile) throws JavaModelException {
        IJavaElement[] javaElems = pkg.getChildren();
        int i = 0;
        while (i < javaElems.length) {
            IJavaElement element = javaElems[i];
            if (element.getElementName().equals(checkFile)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run(IAction action) {
        Shell shell = Activator.getDefault().getShell();
        PackageSelectDialog dialog = null;
        dialog = this.project != null ? new PackageSelectDialog(shell, this.getTitle(), this.project) : new PackageSelectDialog(shell, this.getTitle());
        int res = dialog.open();
        if (res == 0) {
            PackageFragment pkg = dialog.getPackageFragment();
            this.project = pkg.getJavaProject().getElementName();
            Activator.getDefault().setDefaultProject(this.project);
            Iterator iter = this.selection.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                this.invoke(pkg, obj);
            }
        }
    }

    public void invoke(PackageFragment pkg, Object element) {
        if (element instanceof ITable) {
            ITable table = (ITable)element;
            try {
                this.loadColumnInfo(table);
                ICodeGenerator creator = this.createClassCreator(table);
                creator.execute();
                String fileName = String.valueOf(creator.getClassName()) + ".java";
                if (this.existFile(pkg, fileName)) {
                    Shell shell = Activator.getDefault().getShell();
                    MessageBox msg = new MessageBox(shell, 196);
                    msg.setMessage(String.valueOf(fileName) + Messages.getString("GenerateAction.0"));
                    msg.setText(Messages.getString("GenerateAction.1"));
                    int res2 = msg.open();
                    if (res2 == 128) {
                        return;
                    }
                }
                creator.setPackageString(pkg.getElementName());
                this.createFileAndOpen(pkg, fileName, creator.genaratedString());
            }
            catch (Exception e) {
                Activator.getDefault().showErrorDialog(e);
            }
        }
    }

    protected void loadColumnInfo(ITable table) {
        if (!table.isExpanded()) {
            table.setExpanded(true);
            new ColumnSearchAction(this.structuredViewer, table).run();
        }
    }

    public abstract String getTitle();

    public abstract ICodeGenerator createClassCreator(ITable var1);
}

