/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.jdt.ui;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import zigen.plugin.db.ext.jdt.ui.Messages;
import zigen.plugin.db.ext.jdt.ui.SourceDirViewerFilter;

public class PackageSelectDialog
extends TitleAreaDialog {
    private TreeViewer viewer;
    private PackageFragment packageFragment;
    private String defaultProject;
    private String title = Messages.getString("PackageSelectDialog.0");

    public PackageSelectDialog(Shell parentShell, String title) {
        super(parentShell);
        this.title = title;
        parentShell.setText(title);
    }

    public PackageSelectDialog(Shell parentShell, String title, String defaultProject) {
        this(parentShell, title);
        this.defaultProject = defaultProject;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        super.setTitle(this.title);
        super.setMessage(Messages.getString("PackageSelectDialog.1"), 0);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        FillLayout layout = new FillLayout();
        composite2.setLayout((Layout)layout);
        this.viewer = new TreeViewer(composite2, 2048);
        this.viewer.setContentProvider((IContentProvider)new StandardJavaElementContentProvider());
        this.viewer.addFilter((ViewerFilter)new SourceDirViewerFilter());
        JavaElementLabelProvider provider = new JavaElementLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)root);
        this.viewer.setInput((Object)javaModel);
        if (this.defaultProject != null) {
            this.expandDefaultProject(javaModel, this.defaultProject);
        }
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PackageSelectDialog.this.selectionChangeHandler(event);
            }
        });
        return composite;
    }

    private void expandDefaultProject(IJavaModel javaModel, String defaultProject) {
        IJavaProject jProject = javaModel.getJavaProject(defaultProject);
        if (jProject != null && jProject.exists()) {
            IJavaProject myJavaProject = javaModel.getJavaProject(defaultProject);
            this.viewer.expandToLevel((Object)myJavaProject, 2);
        }
    }

    protected Control createContents(Composite parent) {
        Control ctl = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        return ctl;
    }

    private void selectionChangeHandler(SelectionChangedEvent event) {
        Object obj = ((StructuredSelection)event.getSelection()).getFirstElement();
        if (obj instanceof PackageFragment) {
            this.packageFragment = (PackageFragment)obj;
            this.getButton(0).setEnabled(true);
        } else {
            this.packageFragment = null;
            this.getButton(0).setEnabled(false);
        }
    }

    protected Point getInitialSize() {
        return new Point(480, 450);
    }

    public PackageFragment getPackageFragment() {
        return this.packageFragment;
    }
}

