/*
 * 쐬: 2008/08/05
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.entity;

import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.ext.s2jdbc.CodeGenerator;
import zigen.plugin.db.ext.s2jdbc.entity.rule.DefaultEntityMappingFactory;
import zigen.plugin.db.ext.s2jdbc.entity.rule.IEntityMappingFactory;
import zigen.plugin.db.ext.s2jdbc.util.CodeCreatorUtil;
import zigen.plugin.db.ext.s2jdbc.util.CommentUtil;
import zigen.plugin.db.ext.s2jdbc.util.PropertyNameUtil;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.TreeLeaf;

/**
 * S2JDBC EntityCreator.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2005/07/10 ZIGEN create.
 * 
 */
public class EntityGenerator extends CodeGenerator {
	
	private String prefix = ""; //$NON-NLS-1$
	
	private ITable table;
	
	private TreeLeaf[] leafs;
	
	boolean underLineCut = true;
	
	String accessModifiers = "public"; // l public //$NON-NLS-1$
	
	IEntityMappingFactory mapping;
	
	public EntityGenerator(ITable table) {
		this.table = table;
		this.leafs = table.getChildrens();
		this.mapping = DefaultEntityMappingFactory.getFactory(table.getDbConfig());
	}
	
	// vpeB`
	private void do_property() {
		for (int i = 0; i < leafs.length; i++) {
			Column col = (Column) leafs[i];
			println("\t/**"); //$NON-NLS-1$
			// Ame[V_
			println("\t * " + CodeCreatorUtil.getLogicalColumnLabel(col)); //$NON-NLS-1$
			println("\t */"); //$NON-NLS-1$
			
			if ("version".equalsIgnoreCase(col.getName())) {
				println("\t@Version");
				println("\tpublic Long version = 0L;");
				println();
				
			} else {
				
				if (col.hasPrimaryKey()) {
					println("\t@Id");
				}
				// println("\t@Column(name = \"" + col.getName() + "\")");
				println("\t@Column(name = \"" + col.getName().toLowerCase() + "\")"); // S2JDBCłBeanMap̃L[͏
				
				if (mapping.isLargeObject(col.getDataType())) {
					println("\t@Lob");
				}
				
				String temporalType = mapping.getTemporalType(col.getDataType());
				if (temporalType != null) {
					println("\t@Temporal(" + temporalType + ")");
				}
				
				println("\t" + propertyString(accessModifiers, getJavaType(col), PropertyNameUtil.getProperty(col, underLineCut))); //$NON-NLS-1$
				println();
				
			}
			// RgɋLڂĂAme[Vo
			String remarks = col.getRemarks();
			if (remarks != null && !"".equals(remarks.trim())) {
				String ano = CommentUtil.getAnnotation(remarks);
				if (ano != null) {
					if ("@ManyToOne".equalsIgnoreCase(ano)) {
						String entityName = PropertyNameUtil.getEntityFromIdName(col.getName());
						
						println("\t" + ano);
						println("\t@JoinColumn(name = \"" + PropertyNameUtil.getPropertyName(col.getName()) + "\")");
						println("\tpublic " + entityName + " " + PropertyNameUtil.getPropertyName(entityName));
						println();
						
					}
					
				}
				
			}
			
		}
	}
	
	private void do_import() {
		// println("import java.io.Serializable;"); //$NON-NLS-1$
		println("import javax.persistence.*;");
		// println("import java.util.Date;");
		println();
	}
	
	private void do_classBegin() {
		println("@Entity(name = \"" + table.getName() + "\")");
		
		// println("public class " + getClassName() + " implements
		// Serializable{"); //$NON-NLS-1$ //$NON-NLS-2$
		println("public class " + getClassName() + "{"); //$NON-NLS-1$ //$NON-NLS-2$
		println();
		
		// for Serializable
		// println("\tprivate static final long serialVersionUID = 1L;");
		// println();
	}
	
	private void do_classEnd() {
		println("}"); //$NON-NLS-1$
	}
	
	public void execute() {
		super.setGenerateInfo();
		do_import();
		super.setClassComment();
		do_classBegin();
		do_property();
		do_relation();
		do_toString();
		do_classEnd();
	}
	
	public String getClassName() {
		StringBuffer sb = new StringBuffer();
		sb.append(getEntityName());
		sb.append(prefix); // prefix(VO)
		return sb.toString();
	}
	
	protected String getEntityName() {
		return PropertyNameUtil.getEntityName(table.getName());
	}
	
	private void do_toString() {
		String[] properties = new String[leafs.length];
		for (int i = 0; i < leafs.length; i++) {
			Column col = (Column) leafs[i];
			properties[i] = PropertyNameUtil.getProperty(col, underLineCut);
		}
		println(toStringString(getClassName(), properties));
	}
	
	private String getJavaType(Column col) {
		TableColumn tCol = col.getColumn();
		return mapping.getJavaType(tCol);
	}
	
	private boolean hasPrimaryKey() {
		for (int i = 0; i < leafs.length; i++) {
			Column col = (Column) leafs[i];
			TablePKColumn pkColumn = col.getPkColumn();
			if (pkColumn != null) {
				return true;
			}
		}
		return false;
	}
	
	// vpeB`
	private void do_relation() {
		
		TableFKColumn[] fks = table.getTableFKColumns();
		for (int i = 0; i < fks.length; i++) {
			TableFKColumn fk = fks[i];
			String pkTableName = PropertyNameUtil.getEntityName(fk.getPkTableName());
			String pkColumn = PropertyNameUtil.getPropertyName(fk.getPkColumnName());
			String fkColumn = PropertyNameUtil.getPropertyName(fk.getColumnName());
			
			println("\t@ManyToOne");
			println("\t@JoinColumn(name = \"" + fkColumn + "\")");
			println("\tpublic " + pkTableName + " " + PropertyNameUtil.getPropertyName(pkTableName) + ";");
			println();
		}
	}
}
