package zigen.plugin.db.ext.s2jdbc.properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class S2jdbcPropertyPage extends PropertyPage {
	
	public static final String QUALIFIER = "zigen.plugin.db.ext.s2jdbc"; //$NON-NLS-1$
	
	public static final String KEY_ENTITY_SUPERCLASS = "ENTITY_SUPERCLASS"; //$NON-NLS-1$
	
	public static final String KEY_SERVICE_SUPERCLASS = "SERVICE_SUPERCLASS"; //$NON-NLS-1$
	

	private static final String ENTITY_SUPERCLASS = "&Entity̐eNX:";
	
	private static final String SERVICE_SUPERCLASS = "&Service̐eNX:";
	
	// private static final String OWNER_PROPERTY = "&Dto̐eNX";
	
	public static final String DEFAULT_ENTITY_SUPERCLASS = "java.lang.Object";
	
	public static final String DEFAULT_SERVICE_SUPERCLASS = "org.seasar.extension.jdbc.service.S2AbstractService";
	
	private Text entitySuperClassText;
	
	private Text serviceSuperClassText;
	
	private IResource resource;
	
	private String projectName;
	
	
	/**
	 * Constructor for SamplePropertyPage.
	 */
	public S2jdbcPropertyPage() {
		super();
	}
	
	private void addFirstSection(Composite parent) {
		Composite composite = createDefaultComposite(parent);
		
		// Label for path field
		Label label = new Label(composite, SWT.NONE);
		label.setText(ENTITY_SUPERCLASS);
		
		entitySuperClassText = new Text(composite, SWT.SINGLE | SWT.BORDER);
		entitySuperClassText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		try {
			String str = resource.getPersistentProperty(new QualifiedName(QUALIFIER, KEY_ENTITY_SUPERCLASS));
			entitySuperClassText.setText((str != null) ? str : DEFAULT_ENTITY_SUPERCLASS);
			
		} catch (CoreException e) {
			entitySuperClassText.setText(DEFAULT_ENTITY_SUPERCLASS);
		}
		
		// Button btn = new Button(parent, SWT.PUSH);
		// btn.setText("Q");
		// btn.addSelectionListener(new SelectionAdapter() {
		//
		// public void widgetSelected(SelectionEvent selectionevent) {
		// JavaSourceSelectDialog dialog = new JavaSourceSelectDialog(getShell(), ResourcesPlugin.getWorkspace().getRoot(), null, projectName);
		//
		// if (dialog.open() == JavaSourceSelectDialog.OK) {
		// Object[] objs = dialog.getResult();
		//
		// }
		//
		//
		// }
		// });
		
		// Label for path field
		Label label2 = new Label(composite, SWT.NONE);
		label2.setText(SERVICE_SUPERCLASS);
		
		serviceSuperClassText = new Text(composite, SWT.SINGLE | SWT.BORDER);
		serviceSuperClassText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		try {
			String str = resource.getPersistentProperty(new QualifiedName(QUALIFIER, KEY_SERVICE_SUPERCLASS));
			serviceSuperClassText.setText((str != null) ? str : DEFAULT_SERVICE_SUPERCLASS);
			
		} catch (CoreException e) {
			serviceSuperClassText.setText(DEFAULT_SERVICE_SUPERCLASS);
		}
		
	}
	
	// private void addSeparator(Composite parent) {
	// Label separator = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
	// GridData gridData = new GridData();
	// gridData.horizontalAlignment = GridData.FILL;
	// gridData.grabExcessHorizontalSpace = true;
	// separator.setLayoutData(gridData);
	// }
	
	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		// GridData data = new GridData(GridData.FILL);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.grabExcessHorizontalSpace = true;
		composite.setLayoutData(data);
		
		Object obj = getElement();
		if (obj instanceof IResource) {
			resource = (IResource) obj;
		} else if (obj instanceof IJavaProject) {
			IJavaProject jp = (IJavaProject) obj;
			resource = jp.getResource();
			projectName = jp.getElementName();
		}
		
		addFirstSection(composite);
		// addSecondSection(composite);
		// addSeparator(composite);
		return composite;
	}
	
	private Composite createDefaultComposite(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		composite.setLayout(layout);
		
		GridData data = new GridData();
		data.verticalAlignment = GridData.FILL;
		data.horizontalAlignment = GridData.FILL;
		composite.setLayoutData(data);
		
		return composite;
	}
	
	protected void performDefaults() {
		entitySuperClassText.setText(DEFAULT_ENTITY_SUPERCLASS);
		serviceSuperClassText.setText(DEFAULT_SERVICE_SUPERCLASS);
	}
	
	public boolean performOk() {
		try {
			resource.setPersistentProperty(new QualifiedName(QUALIFIER, KEY_ENTITY_SUPERCLASS), entitySuperClassText.getText());
			resource.setPersistentProperty(new QualifiedName(QUALIFIER, KEY_SERVICE_SUPERCLASS), serviceSuperClassText.getText());
		} catch (CoreException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
}