/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.ui.internal.ITable;

public class TableElement
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected ITable table;
    protected int recordNo;
    protected TableColumn[] columns;
    protected Object[] items;
    protected TableColumn[] uniqueColumns;
    protected Object[] uniqueItems;
    protected Object[] orgItems;
    protected List modifiedList = new ArrayList();
    protected boolean isNew = false;
    protected boolean canModify = true;
    protected TablePKColumn[] pks;
    protected List fks;
    protected boolean updatedDataBase;

    public void copy(TableElement src) {
        this.items = src.items;
        this.orgItems = src.orgItems;
    }

    public boolean hasTablePKColumn() {
        return this.pks != null;
    }

    public boolean hasTableFKColumn() {
        return this.fks != null;
    }

    public void setTablePKColumn(TablePKColumn[] pks) {
        this.pks = pks;
    }

    public void setTableFKColumn(TableFKColumn[] fks) {
        this.fks = this.convertTableFKColumn(fks);
    }

    public List convertTableFKColumn(TableFKColumn[] fks) {
        ArrayList<TableFKColumn[]> result = new ArrayList<TableFKColumn[]>();
        String temp = "";
        int i = 0;
        while (i < fks.length) {
            TableFKColumn fkc = fks[i];
            temp = fkc.getName();
            ArrayList<TableFKColumn> list = new ArrayList<TableFKColumn>();
            int k = i;
            while (k < fks.length) {
                TableFKColumn _fkc = fks[k];
                if (!temp.equals(_fkc.getName())) break;
                list.add(_fkc);
                i += k;
                temp = _fkc.getName();
                ++k;
            }
            result.add(list.toArray(new TableFKColumn[0]));
            ++i;
        }
        return result;
    }

    public void addMofiedColumn(int colIndex) {
        if (!(this.columns == null && colIndex > this.columns.length - 1 || this.modifiedList.contains(this.columns[colIndex]))) {
            this.modifiedList.add(this.columns[colIndex]);
        }
    }

    public boolean isModify() {
        return this.modifiedList.size() > 0;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public TableColumn[] getModifiedColumns() {
        return this.modifiedList.toArray(new TableColumn[0]);
    }

    public Object[] getModifiedItems() {
        Object[] modifiedValues = new Object[this.modifiedList.size()];
        int i = 0;
        while (i < this.modifiedList.size()) {
            modifiedValues[i] = this.getItem((TableColumn)this.modifiedList.get(i));
            ++i;
        }
        return modifiedValues;
    }

    public Object getItem(TableColumn column) {
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i].equals(column)) {
                return this.items[i];
            }
            ++i;
        }
        return null;
    }

    public Object getItem(int index) {
        return this.items[index];
    }

    public TableElement(int recordNo, TableColumn[] columns, Object[] items) {
        this.recordNo = recordNo;
        this.columns = columns;
        this.items = items;
    }

    public TableElement(ITable table, int recordNo, TableColumn[] columns, Object[] items, TableColumn[] uniqueColumns, Object[] uniqueItems) {
        this.table = table;
        this.recordNo = recordNo;
        this.columns = columns;
        this.uniqueColumns = uniqueColumns;
        this.uniqueItems = uniqueItems;
        this.items = items;
        if (items != null) {
            this.orgItems = new Object[items.length];
            System.arraycopy(items, 0, this.orgItems, 0, items.length);
        }
    }

    public int getRecordNo() {
        return this.recordNo;
    }

    public Object[] getItems() {
        return this.items;
    }

    public TableColumn[] getColumns() {
        return this.columns;
    }

    public TableColumn[] getUniqueColumns() {
        return this.uniqueColumns;
    }

    public Object[] getUniqueItems() {
        return this.uniqueItems;
    }

    protected Object padding(int index, Object obj) {
        String nullSymbol;
        String value;
        if (obj instanceof String && !(value = String.valueOf(obj)).equals(nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol"))) {
            TableColumn column = this.columns[index];
            int type = column.getDataType();
            int size = column.getColumnSize();
            switch (type) {
                case 1: {
                    return StringUtil.padding(value, size);
                }
            }
        }
        return obj;
    }

    public void updateItems(int index, Object obj) {
        this.items[index] = this.padding(index, obj);
        this.addMofiedColumn(index);
    }

    public boolean isCanModify() {
        return this.canModify;
    }

    public void setCanModify(boolean canModify) {
        this.canModify = canModify;
    }

    public ITable getTable() {
        return this.table;
    }

    public void setTable(ITable table) {
        this.table = table;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TableElement:");
        buffer.append(" table: ");
        buffer.append(this.table);
        buffer.append(" recordNo: ");
        buffer.append(this.recordNo);
        buffer.append(" { ");
        int i0 = 0;
        while (this.columns != null && i0 < this.columns.length) {
            buffer.append(" columns[" + i0 + "]: ");
            buffer.append(this.columns[i0]);
            ++i0;
        }
        buffer.append(" } ");
        buffer.append(" { ");
        i0 = 0;
        while (this.items != null && i0 < this.items.length) {
            buffer.append(" items[" + i0 + "]: ");
            buffer.append(this.items[i0]);
            ++i0;
        }
        buffer.append(" } ");
        buffer.append(" { ");
        i0 = 0;
        while (this.uniqueColumns != null && i0 < this.uniqueColumns.length) {
            buffer.append(" uniqueColumns[" + i0 + "]: ");
            buffer.append(this.uniqueColumns[i0]);
            ++i0;
        }
        buffer.append(" } ");
        buffer.append(" { ");
        i0 = 0;
        while (this.uniqueItems != null && i0 < this.uniqueItems.length) {
            buffer.append(" uniqueItems[" + i0 + "]: ");
            buffer.append(this.uniqueItems[i0]);
            ++i0;
        }
        buffer.append(" } ");
        buffer.append(" modifiedList: ");
        buffer.append(this.modifiedList);
        buffer.append(" isNew: ");
        buffer.append(this.isNew);
        buffer.append(" canModify: ");
        buffer.append(this.canModify);
        buffer.append("]");
        return buffer.toString();
    }

    public Object[] getOrgItems() {
        return this.orgItems;
    }

    public void modifyUniqueItems() {
        Object[] uniequeItems = new Object[this.uniqueColumns.length];
        int i = 0;
        while (i < this.uniqueColumns.length) {
            TableColumn uCol = this.uniqueColumns[i];
            int k = 0;
            while (k < this.columns.length) {
                TableColumn col = this.columns[k];
                if (col.getColumnName().equals(uCol.getColumnName())) {
                    uniequeItems[i] = this.items[k];
                    break;
                }
                ++k;
            }
            ++i;
        }
        this.uniqueItems = uniequeItems;
    }

    public void clearMofiedColumn() {
        this.modifiedList = new ArrayList();
    }

    public boolean isUpdatedDataBase() {
        return this.updatedDataBase;
    }

    public void setUpdatedDataBase(boolean updatedDataBase) {
        this.updatedDataBase = updatedDataBase;
    }

    public void setRecordNo(int recordNo) {
        this.recordNo = recordNo;
    }

    public void isNew(boolean isNew) {
        this.isNew = isNew;
    }
}

