/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.sql;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.parser.util.CurrentSql;
import zigen.plugin.db.ui.editors.sql.SqlEditor2;
import zigen.plugin.db.ui.editors.sql.SqlExecJob2;
import zigen.plugin.db.ui.views.internal.SQLOutinePage;
import zigen.sql.parser.INode;
import zigen.sql.parser.ast.ASTAlias;
import zigen.sql.parser.ast.ASTStatement;

public class ExecuteAction
implements IObjectActionDelegate {
    IAction action;
    IStructuredSelection selection;
    StructuredViewer structuredViewer;
    SQLOutinePage page;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        ContentOutline outline;
        if (targetPart instanceof ContentOutline && (outline = (ContentOutline)targetPart).getCurrentPage() instanceof SQLOutinePage) {
            this.page = (SQLOutinePage)outline.getCurrentPage();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
        if (!(selection instanceof IStructuredSelection)) {
            this.action.setEnabled(false);
            throw new RuntimeException("Required IStructuredSelection.");
        }
        this.selection = (IStructuredSelection)selection;
        this.action.setEnabled(true);
    }

    public void run(IAction action) {
        Object obj = this.selection.getFirstElement();
        if (obj instanceof ASTStatement) {
            ASTAlias as;
            ASTStatement st = (ASTStatement)obj;
            INode last = this.getEndNode((INode)st);
            int offset = st.getOffset();
            int length = last.getOffset() + last.getLength() - offset;
            if (last instanceof ASTAlias && (as = (ASTAlias)last).hasAlias()) {
                length = as.getAliasOffset() + as.getAliasLength() - offset;
            }
            SqlEditor2 editor = this.page.getEditor();
            editor.toolBar.setDisplayResultChecked(true);
            CurrentSql cs = this.page.getCurrentSql();
            Transaction trans = Transaction.getInstance(editor.getDBConfig());
            String sql = cs.getSql().substring(offset, offset + length);
            if (sql != null && sql.trim().length() > 0) {
                SqlExecJob2 job = new SqlExecJob2(editor, trans, sql);
                job.setUser(false);
                job.schedule();
            }
        }
    }

    public INode getEndNode(INode node) {
        INode n = node.getLastChild();
        if (n == null) {
            return node;
        }
        return this.getEndNode(n);
    }
}

