/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SchemaInfo;

public class DBConfig
implements IDBConfig,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int JDBC_DRIVER_TYPE_2 = 2;
    public static final int JDBC_DRIVER_TYPE_4 = 4;
    private String dbName;
    private String driverName;
    private String url;
    private String userId;
    private String password;
    private String schema;
    private String[] classPaths;
    private String charset;
    private boolean isConvertUnicode;
    private int dbType = -1;
    private boolean isAutoCommit;
    private boolean onlyDefaultSchema;
    private int jdbcType = 4;
    private boolean isSavePassword;
    private String driverVersion;
    private String databaseProductVersion;
    private int dataBaseProductMajorVersion;
    private int dataBaseProductMinorVersion;
    private boolean isConnectAsSYSDBA;
    private boolean isConnectAsSYSOPER;
    private boolean isConnectAsInformationSchema;
    private SchemaInfo[] displayedSchemas;
    private String filterPattern;
    private boolean checkFilterPattern;
    boolean isNoLockMode;

    public String[] getClassPaths() {
        return this.classPaths;
    }

    public void setClassPaths(String[] classPaths) {
        this.classPaths = classPaths;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
        this.dbType = DBType.getType(driverName);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("user", this.getUserId());
        properties.setProperty("password", this.getPassword());
        if (this.getSchema() != null) {
            properties.setProperty("schema", this.getSchema());
        }
        if (this.getCharset() != null && !this.getCharset().equals("")) {
            switch (DBType.getType(this.driverName)) {
                case 2: {
                    properties.setProperty("charSet", this.getCharset());
                    properties.setProperty("useUnicode", "true");
                    properties.setProperty("characterEncoding", this.getCharset());
                    break;
                }
                default: {
                    properties.setProperty("charSet", this.getCharset());
                    properties.setProperty("useUnicode", "true");
                    properties.setProperty("characterEncoding", this.getCharset());
                }
            }
        }
        if (DBType.getType(this.driverName) == 1) {
            if (this.isConnectAsSYSDBA) {
                properties.setProperty("internal_logon", "sysdba");
            }
            if (this.isConnectAsSYSOPER) {
                properties.setProperty("internal_logon", "sysoper");
            }
        } else if (DBType.getType(this.driverName) == 2) {
            if (this.isConnectAsInformationSchema) {
                properties.setProperty("useInformationSchema", "true");
            } else {
                properties.setProperty("useInformationSchema", "false");
            }
        }
        return properties;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSchema() {
        if (this.schema != null) {
            return this.schema;
        }
        return this.userId;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isConvertUnicode() {
        return this.isConvertUnicode;
    }

    public void setConvertUnicode(boolean isConvertUnicode) {
        this.isConvertUnicode = isConvertUnicode;
    }

    public int getDbType() {
        return this.dbType;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    public void setDbType(int dbType) {
        this.dbType = dbType;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public void setAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public boolean isOnlyDefaultSchema() {
        return this.onlyDefaultSchema;
    }

    public void setOnlyDefaultSchema(boolean b) {
        this.onlyDefaultSchema = b;
    }

    public boolean isNoLockMode() {
        return this.isNoLockMode;
    }

    public void setNoLockMode(boolean isNoLockMode) {
        this.isNoLockMode = isNoLockMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        DBConfig castedObj = (DBConfig)o;
        return (this.dbName == null ? castedObj.dbName == null : this.dbName.equals(castedObj.dbName)) && (this.driverName == null ? castedObj.driverName == null : this.driverName.equals(castedObj.driverName)) && (this.url == null ? castedObj.url == null : this.url.equals(castedObj.url)) && (this.userId == null ? castedObj.userId == null : this.userId.equals(castedObj.userId)) && (this.password == null ? castedObj.password == null : this.password.equals(castedObj.password)) && (this.schema == null ? castedObj.schema == null : this.schema.equals(castedObj.schema)) && Arrays.equals(this.classPaths, castedObj.classPaths) && (this.charset == null ? castedObj.charset == null : this.charset.equals(castedObj.charset)) && this.isConvertUnicode == castedObj.isConvertUnicode && this.dbType == castedObj.dbType && (this.driverVersion == null ? castedObj.driverVersion == null : this.driverVersion.equals(castedObj.driverVersion)) && this.isAutoCommit == castedObj.isAutoCommit && this.onlyDefaultSchema == castedObj.onlyDefaultSchema && this.jdbcType == castedObj.jdbcType && this.isSavePassword == castedObj.isSavePassword && this.isNoLockMode == castedObj.isNoLockMode;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(int jdbcType) {
        this.jdbcType = jdbcType;
    }

    public boolean isSavePassword() {
        return this.isSavePassword;
    }

    public void setSavePassword(boolean b) {
        this.isSavePassword = b;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DBConfig:");
        buffer.append(" JDBC_DRIVER_TYPE_2: ");
        buffer.append(2);
        buffer.append(" JDBC_DRIVER_TYPE_4: ");
        buffer.append(4);
        buffer.append(" dbName: ");
        buffer.append(this.dbName);
        buffer.append(" driverName: ");
        buffer.append(this.driverName);
        buffer.append(" url: ");
        buffer.append(this.url);
        buffer.append(" userId: ");
        buffer.append(this.userId);
        buffer.append(" password: ");
        buffer.append(this.password);
        buffer.append(" schema: ");
        buffer.append(this.schema);
        buffer.append(" { ");
        int i0 = 0;
        while (this.classPaths != null && i0 < this.classPaths.length) {
            buffer.append(" classPaths[" + i0 + "]: ");
            buffer.append(this.classPaths[i0]);
            ++i0;
        }
        buffer.append(" } ");
        buffer.append(" charset: ");
        buffer.append(this.charset);
        buffer.append(" isConvertUnicode: ");
        buffer.append(this.isConvertUnicode);
        buffer.append(" dbType: ");
        buffer.append(this.dbType);
        buffer.append(" driverVersion: ");
        buffer.append(this.driverVersion);
        buffer.append(" isAutoCommit: ");
        buffer.append(this.isAutoCommit);
        buffer.append(" onlyDefaultSchema: ");
        buffer.append(this.onlyDefaultSchema);
        buffer.append(" jdbcType: ");
        buffer.append(this.jdbcType);
        buffer.append(" isSavePassword: ");
        buffer.append(this.isSavePassword);
        buffer.append(" isNoLockMode: ");
        buffer.append(this.isNoLockMode);
        buffer.append("]");
        return buffer.toString();
    }

    public Object clone() {
        int i0;
        DBConfig inst = new DBConfig();
        inst.dbName = this.dbName == null ? null : new String(this.dbName);
        inst.driverName = this.driverName == null ? null : new String(this.driverName);
        inst.url = this.url == null ? null : new String(this.url);
        inst.userId = this.userId == null ? null : new String(this.userId);
        inst.password = this.password == null ? null : new String(this.password);
        String string = inst.schema = this.schema == null ? null : new String(this.schema);
        if (this.classPaths != null) {
            inst.classPaths = new String[this.classPaths.length];
            i0 = 0;
            while (i0 < this.classPaths.length) {
                inst.classPaths[i0] = this.classPaths[i0] == null ? null : new String(this.classPaths[i0]);
                ++i0;
            }
        } else {
            inst.classPaths = null;
        }
        inst.charset = this.charset == null ? null : new String(this.charset);
        inst.isConvertUnicode = this.isConvertUnicode;
        inst.dbType = this.dbType;
        inst.driverVersion = this.driverVersion == null ? null : new String(this.driverVersion);
        inst.isAutoCommit = this.isAutoCommit;
        inst.onlyDefaultSchema = this.onlyDefaultSchema;
        inst.jdbcType = this.jdbcType;
        inst.isSavePassword = this.isSavePassword;
        inst.isNoLockMode = this.isNoLockMode;
        inst.dataBaseProductMajorVersion = this.dataBaseProductMajorVersion;
        inst.dataBaseProductMinorVersion = this.dataBaseProductMinorVersion;
        inst.databaseProductVersion = this.databaseProductVersion;
        inst.isConnectAsSYSDBA = this.isConnectAsSYSDBA;
        inst.isConnectAsSYSOPER = this.isConnectAsSYSOPER;
        inst.displayedSchemas = this.displayedSchemas;
        if (this.displayedSchemas != null) {
            inst.displayedSchemas = new SchemaInfo[this.displayedSchemas.length];
            i0 = 0;
            while (i0 < this.displayedSchemas.length) {
                SchemaInfo schemaInfo = inst.displayedSchemas[i0] = this.displayedSchemas[i0] == null ? null : this.displayedSchemas[i0];
                if (inst.displayedSchemas != null) {
                    inst.displayedSchemas[i0].setConfig(inst);
                }
                ++i0;
            }
        } else {
            inst.displayedSchemas = null;
        }
        inst.checkFilterPattern = this.checkFilterPattern;
        inst.filterPattern = this.filterPattern;
        return inst;
    }

    public int getDataBaseProductMajorVersion() {
        return this.dataBaseProductMajorVersion;
    }

    public void setDatabaseProductMajorVersion(int dataBaseProductMajorVersion) {
        this.dataBaseProductMajorVersion = dataBaseProductMajorVersion;
    }

    public int getDataBaseProductMinorVersion() {
        return this.dataBaseProductMinorVersion;
    }

    public void setDatabaseProductMinorVersion(int dataBaseProductMinorVersion) {
        this.dataBaseProductMinorVersion = dataBaseProductMinorVersion;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String databaseProductVersion) {
        this.databaseProductVersion = databaseProductVersion;
    }

    public boolean isConnectAsSYSDBA() {
        return this.isConnectAsSYSDBA;
    }

    public boolean isConnectAsSYSOPER() {
        return this.isConnectAsSYSOPER;
    }

    public void setConnectAsSYSDBA(boolean b) {
        this.isConnectAsSYSDBA = b;
    }

    public void setConnectAsSYSOPER(boolean b) {
        this.isConnectAsSYSOPER = b;
    }

    public SchemaInfo[] getDisplayedSchemas() {
        if (this.displayedSchemas != null) {
            int i = 0;
            while (i < this.displayedSchemas.length) {
                this.displayedSchemas[i].setConfig(this);
                ++i;
            }
        }
        return this.displayedSchemas;
    }

    public void setDisplayedSchemas(SchemaInfo[] schemas) {
        this.displayedSchemas = schemas;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public boolean isCheckFilterPattern() {
        return this.checkFilterPattern;
    }

    public void setCheckFilterPattern(boolean checkFilterPattern) {
        this.checkFilterPattern = checkFilterPattern;
    }

    public boolean isConnectAsInformationSchema() {
        return this.isConnectAsInformationSchema;
    }

    public void setConnectAsInformationSchema(boolean isConnectAsInformationSchema) {
        this.isConnectAsInformationSchema = isConnectAsInformationSchema;
    }
}

