/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PartInitException;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.jobs.ConnectDBJob;
import zigen.plugin.db.ui.views.TreeContentProvider;
import zigen.plugin.db.ui.views.TreeView;

public class ConfirmConnectDBAction
extends Action
implements Runnable {
    PluginSettingsManager pluginSettingsManager = DbPlugin.getDefault().getPluginSettingsManager();
    Transaction trans = null;
    IPreferenceStore store;

    public ConfirmConnectDBAction(Transaction trans) {
        this.trans = trans;
        this.store = DbPlugin.getDefault().getPreferenceStore();
    }

    public void run() {
        try {
            IDBConfig config = this.trans.getConfig();
            boolean b = this.store.getBoolean("PreferencePage.NoConfirmConnectDB");
            if (b) {
                this.connect(config);
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append(config.getDbName());
                sb.append(Messages.getString("ConfirmConnectDBAction.1"));
                String msg = sb.toString();
                String opt = Messages.getString("ConfirmConnectDBAction.0");
                MessageDialogWithToggle dialog = DbPlugin.getDefault().confirmDialogWithToggle(msg, opt, false);
                if (dialog.getReturnCode() == 2) {
                    this.store.setValue("PreferencePage.NoConfirmConnectDB", dialog.getToggleState());
                    this.connect(config);
                }
            }
        }
        catch (PartInitException e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private void connect(IDBConfig config) throws PartInitException {
        TreeContentProvider cp;
        Root root;
        TreeLeaf node;
        TreeView view = (TreeView)DbPlugin.findView("zigen.plugin.db.ui.views.TreeView");
        if (view == null) {
            view = (TreeView)DbPlugin.showView("zigen.plugin.db.ui.views.TreeView");
        }
        if ((node = (root = (cp = view.getContentProvider()).getRoot()).getChild(config.getDbName())) != null && node instanceof DataBase) {
            DataBase db = (DataBase)node;
            db.setConnected(true);
            ConnectDBJob job = new ConnectDBJob(view.getTreeViewer(), db);
            job.setPriority(20);
            job.setUser(false);
            job.setSystem(false);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                DbPlugin.log(e);
            }
        }
    }
}

