/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.InputStreamUtil;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.actions.SQLSourceViewerAction;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class OpenSQLAction
extends SQLSourceViewerAction {
    public OpenSQLAction(SQLSourceViewer viewer) {
        super(viewer);
        this.setText(Messages.getString("OpenSQLAction.0"));
        this.setToolTipText(Messages.getString("OpenSQLAction.1"));
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
    }

    public void run() {
        try {
            Shell shell = DbPlugin.getDefault().getShell();
            FileDialog dialog = new FileDialog(shell, 4096);
            if (this.fSQLSourceViewer.getSqlFileName() != null) {
                dialog.setFileName(this.fSQLSourceViewer.getSqlFileName());
            }
            dialog.setFilterExtensions(new String[]{"*.sql", "*.*"});
            dialog.setFilterNames(new String[]{Messages.getString("OpenSQLAction.4"), Messages.getString("OpenSQLAction.5")});
            String fileName = dialog.open();
            if (fileName == null) {
                return;
            }
            File file = new File(fileName);
            String charset = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.SqlFileCharset");
            if (file.exists() && file.canRead()) {
                String sqlData = InputStreamUtil.toString(new FileInputStream(file), charset);
                this.fSQLSourceViewer.getDocument().set(sqlData);
                this.fSQLSourceViewer.setSqlFile(file);
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

